/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.AddSplitHeadersFilter;
import io.split.client.CachedTreatmentLogRemovalListener;
import io.split.client.HardcodedFeatureTreatmentsSplitClient;
import io.split.client.HttpSegmentChangeFetcher;
import io.split.client.HttpSplitChangeFetcher;
import io.split.client.LocalhostSplitClientBuilder;
import io.split.client.ObjectMapperProvider;
import io.split.client.SplitClient;
import io.split.client.SplitClientConfig;
import io.split.client.SplitClientImpl;
import io.split.client.jmx.JmxMonitor;
import io.split.client.jmx.SplitJmxMonitor;
import io.split.client.metrics.CachedMetrics;
import io.split.client.metrics.FireAndForgetMetrics;
import io.split.client.metrics.HttpMetrics;
import io.split.engine.experiments.RefreshableSplitFetcherProvider;
import io.split.engine.experiments.SplitFetcher;
import io.split.engine.experiments.SplitParser;
import io.split.engine.impressions.CachedTreatmentLog;
import io.split.engine.segments.RefreshableSegmentFetcher;
import io.split.engine.segments.SegmentFetcher;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.filter.EncodingFilter;
import org.glassfish.jersey.filter.LoggingFilter;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.message.GZipEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitClientBuilder {
    private static final Logger _log = LoggerFactory.getLogger(SplitClientBuilder.class);
    private static Random RANDOM = new Random();
    private static AtomicReference<SplitClient> _client = new AtomicReference();
    private static Object _lock = new Object();

    public static SplitClient build(String apiToken) throws IOException {
        return SplitClientBuilder.build(apiToken, SplitClientConfig.builder().build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SplitClient build(String apiToken, SplitClientConfig config) throws IOException {
        if (_client.get() != null) {
            return _client.get();
        }
        Object object = _lock;
        synchronized (object) {
            if (_client.get() != null) {
                return _client.get();
            }
            if ("localhost".equals(apiToken)) {
                HardcodedFeatureTreatmentsSplitClient splitClient = LocalhostSplitClientBuilder.build();
                _client.set(splitClient);
                SplitClientBuilder.registerJmxMonitor(splitClient);
                return splitClient;
            }
            Client client = ClientBuilder.newClient((Configuration)((Object)((ClientConfig)((ClientConfig)((ClientConfig)new ClientConfig().property("jersey.config.client.connectTimeout", config.connectionTimeoutInMs()).property("jersey.config.client.readTimeout", config.readTimeoutInMs()).register(AddSplitHeadersFilter.instance(apiToken)).register((Class)ObjectMapperProvider.class)).register((Class)JacksonFeature.class)).register((Class)GZipEncoder.class)).register((Class)EncodingFilter.class)));
            if (config.debugEnabled()) {
                client.register(new LoggingFilter());
            }
            WebTarget rootTarget = client.target(config.endpoint());
            HttpMetrics httpMetrics = HttpMetrics.create(rootTarget);
            FireAndForgetMetrics uncachedFireAndForget = FireAndForgetMetrics.instance(httpMetrics, 2, 1000);
            HttpSegmentChangeFetcher segmentChangeFetcher = HttpSegmentChangeFetcher.create(rootTarget, uncachedFireAndForget);
            RefreshableSegmentFetcher segmentFetcher = new RefreshableSegmentFetcher(segmentChangeFetcher, SplitClientBuilder.findPollingPeriod(RANDOM, config.pollForSegmentChangesEveryNSeconds()), config.numThreadsForSegmentFetch());
            SplitParser splitParser = new SplitParser(segmentFetcher);
            HttpSplitChangeFetcher splitChangeFetcher = HttpSplitChangeFetcher.create(rootTarget, uncachedFireAndForget);
            RefreshableSplitFetcherProvider experimentFetcherProvider = new RefreshableSplitFetcherProvider(splitChangeFetcher, splitParser, SplitClientBuilder.findPollingPeriod(RANDOM, config.pollForFeatureChangesEveryNSeconds()));
            CachedTreatmentLog treatmentLog = CachedTreatmentLog.instance(config.treatmentLogCacheExpireNSecondsAfterWrite(), 1000, CachedTreatmentLogRemovalListener.create(rootTarget));
            CachedMetrics cachedMetrics = new CachedMetrics(httpMetrics, 100);
            FireAndForgetMetrics cachedFireAndForgetMetrics = FireAndForgetMetrics.instance(cachedMetrics, 2, 1000);
            SplitClientImpl splitClient = new SplitClientImpl(experimentFetcherProvider.getFetcher(), treatmentLog, cachedFireAndForgetMetrics);
            SplitClientBuilder.registerJmxMonitor(splitClient, experimentFetcherProvider.getFetcher(), segmentFetcher);
            _client.set(splitClient);
            return splitClient;
        }
    }

    private static void registerJmxMonitor(SplitClient splitClient) {
        SplitClientBuilder.registerJmxMonitor(splitClient, null, null);
    }

    private static void registerJmxMonitor(SplitClient splitClient, SplitFetcher fetcher, SegmentFetcher segmentFetcher) {
        try {
            SplitJmxMonitor mbean = new SplitJmxMonitor(splitClient, fetcher, segmentFetcher);
            JmxMonitor.getInstance().registerMonitor("io.split.monitor", "Split", mbean);
        }
        catch (Exception e) {
            _log.warn("Unable to create JMX monitor", e);
        }
    }

    private static int findPollingPeriod(Random rand, int max) {
        int min = max / 2;
        return rand.nextInt(max - min + 1) + min;
    }

    public static void main(String ... args) throws IOException {
        if (args.length != 1) {
            System.out.println("Usage: <api_token>");
            System.exit(1);
            return;
        }
        SplitClientConfig config = SplitClientConfig.builder().endpoint("http://localhost:8081/api").enableDebug().build();
        SplitClient client = SplitClientBuilder.build(args[0], config);
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String line = reader.readLine();
            while (line != null) {
                String[] userIdAndSplit;
                if ("exit".equals(line)) {
                    System.exit(0);
                }
                if ((userIdAndSplit = line.split(" ")).length != 2) {
                    System.out.println("Could not understand command");
                } else {
                    boolean isOn = client.getTreatment(userIdAndSplit[0], userIdAndSplit[1]).equals("on");
                    System.out.println(isOn ? "on" : "off");
                }
                line = reader.readLine();
            }
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }
}

