/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.matchers;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.codigo.dtos.MatcherCombiner;
import io.split.engine.matchers.AttributeMatcher;
import io.split.engine.matchers.Matcher;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CombiningMatcher {
    private final ImmutableList<AttributeMatcher> _delegates;
    private final MatcherCombiner _combiner;

    public static CombiningMatcher of(Matcher matcher) {
        return new CombiningMatcher(MatcherCombiner.AND, Lists.newArrayList(AttributeMatcher.vanilla(matcher)));
    }

    public CombiningMatcher(MatcherCombiner combiner, List<AttributeMatcher> delegates) {
        this._delegates = ImmutableList.copyOf(delegates);
        this._combiner = combiner;
        Preconditions.checkArgument(this._delegates.size() > 0);
    }

    public boolean match(String key, Map<String, Object> attributes) {
        if (this._delegates.isEmpty()) {
            return false;
        }
        switch (this._combiner) {
            case AND: {
                return this.and(key, attributes);
            }
        }
        throw new IllegalArgumentException("Unknown combiner: " + (Object)((Object)this._combiner));
    }

    private boolean and(String key, Map<String, Object> attributes) {
        boolean result = true;
        for (AttributeMatcher delegate : this._delegates) {
            result &= delegate.match(key, attributes);
        }
        return result;
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("if");
        boolean first = true;
        for (AttributeMatcher matcher : this._delegates) {
            if (!first) {
                bldr.append(" " + (Object)((Object)this._combiner));
            }
            bldr.append(" ");
            bldr.append(matcher);
            first = false;
        }
        return bldr.toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._combiner, this._delegates});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CombiningMatcher)) {
            return false;
        }
        CombiningMatcher other = (CombiningMatcher)obj;
        return this._combiner.equals((Object)other._combiner) && this._delegates.equals(other._delegates);
    }
}

