/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.matchers;

import com.google.common.base.Preconditions;
import io.split.engine.matchers.Matcher;
import io.split.engine.segments.Segment;

public class UserDefinedSegmentMatcher
implements Matcher {
    private final String _segmentName;
    private final Segment _segment;

    public UserDefinedSegmentMatcher(Segment segment) {
        Preconditions.checkNotNull(segment);
        this._segmentName = segment.segmentName();
        this._segment = segment;
        Preconditions.checkNotNull(this._segmentName);
    }

    @Override
    public boolean match(Object key) {
        if (!(key instanceof String)) {
            return false;
        }
        return this._segment.contains((String)key);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this._segmentName.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UserDefinedSegmentMatcher)) {
            return false;
        }
        UserDefinedSegmentMatcher other = (UserDefinedSegmentMatcher)obj;
        return this._segmentName.equals(other._segmentName);
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("in segment ");
        bldr.append(this._segmentName);
        return bldr.toString();
    }
}

