/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.matchers;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.split.engine.matchers.Matcher;
import java.util.Collection;
import java.util.Set;

public class WhitelistMatcher
implements Matcher {
    private final Set<String> _whitelist = Sets.newHashSet();

    public WhitelistMatcher(Collection<String> whitelist) {
        Preconditions.checkNotNull(whitelist);
        this._whitelist.addAll(whitelist);
    }

    @Override
    public boolean match(Object key) {
        return this._whitelist.contains(key);
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("in segment [");
        boolean first = true;
        for (String item : this._whitelist) {
            if (!first) {
                bldr.append(',');
            }
            bldr.append('\"');
            bldr.append(item);
            bldr.append('\"');
            first = false;
        }
        bldr.append("]");
        return bldr.toString();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this._whitelist.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WhitelistMatcher)) {
            return false;
        }
        WhitelistMatcher other = (WhitelistMatcher)obj;
        return this._whitelist.equals(other._whitelist);
    }
}

