/*
 * Decompiled with CFR 0.152.
 */
package io.codigo.dtos;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.codigo.dtos.Partition;

final class AutoValue_Partition
extends Partition {
    private final String treatment;
    private final int size;

    private AutoValue_Partition(String treatment, int size) {
        if (treatment == null) {
            throw new NullPointerException("Null treatment");
        }
        this.treatment = treatment;
        this.size = size;
    }

    @Override
    @JsonProperty
    public String treatment() {
        return this.treatment;
    }

    @Override
    @JsonProperty
    public int size() {
        return this.size;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Partition) {
            Partition that = (Partition)o;
            return this.treatment.equals(that.treatment()) && this.size == that.size();
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.treatment.hashCode();
        h *= 1000003;
        return h ^= this.size;
    }

    static final class Builder
    extends Partition.Builder {
        private String treatment;
        private Integer size;

        Builder() {
        }

        Builder(Partition source) {
            this.treatment = source.treatment();
            this.size = source.size();
        }

        @Override
        public Partition.Builder treatment(String treatment) {
            this.treatment = treatment;
            return this;
        }

        @Override
        public Partition.Builder size(int size) {
            this.size = size;
            return this;
        }

        @Override
        public Partition autobuild() {
            String missing = "";
            if (this.treatment == null) {
                missing = missing + " treatment";
            }
            if (this.size == null) {
                missing = missing + " size";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_Partition(this.treatment, this.size);
        }
    }
}

