/*
 * Decompiled with CFR 0.152.
 */
package io.codigo.dtos;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.codigo.dtos.WhitelistMatcherData;
import java.util.List;

final class AutoValue_WhitelistMatcherData
extends WhitelistMatcherData {
    private final ImmutableList<String> whitelist;

    private AutoValue_WhitelistMatcherData(ImmutableList<String> whitelist) {
        if (whitelist == null) {
            throw new NullPointerException("Null whitelist");
        }
        this.whitelist = whitelist;
    }

    @Override
    @JsonProperty
    public ImmutableList<String> whitelist() {
        return this.whitelist;
    }

    public String toString() {
        return "WhitelistMatcherData{whitelist=" + this.whitelist + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof WhitelistMatcherData) {
            WhitelistMatcherData that = (WhitelistMatcherData)o;
            return this.whitelist.equals(that.whitelist());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= this.whitelist.hashCode();
    }

    static final class Builder
    extends WhitelistMatcherData.Builder {
        private ImmutableList<String> whitelist;

        Builder() {
        }

        Builder(WhitelistMatcherData source) {
            this.whitelist = source.whitelist();
        }

        @Override
        public WhitelistMatcherData.Builder whitelist(List<String> whitelist) {
            this.whitelist = ImmutableList.copyOf(whitelist);
            return this;
        }

        @Override
        public WhitelistMatcherData build() {
            String missing = "";
            if (this.whitelist == null) {
                missing = missing + " whitelist";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_WhitelistMatcherData(this.whitelist);
        }
    }
}

