/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import com.google.common.base.Preconditions;
import io.codigo.dtos.SegmentChange;
import io.split.engine.metrics.Metrics;
import io.split.engine.segments.SegmentChangeFetcher;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpSegmentChangeFetcher
implements SegmentChangeFetcher {
    private static final Logger _log = LoggerFactory.getLogger(HttpSegmentChangeFetcher.class);
    private static final String PREFIX = "segmentChangeFetcher";
    private final WebTarget _target;
    private static final String SINCE = "since";
    private final Metrics _metrics;

    public static HttpSegmentChangeFetcher create(WebTarget root) {
        return HttpSegmentChangeFetcher.create(root, new Metrics.NoopMetrics());
    }

    public static HttpSegmentChangeFetcher create(WebTarget root, Metrics metrics) {
        return new HttpSegmentChangeFetcher(root.path("segmentChanges"), metrics);
    }

    private HttpSegmentChangeFetcher(WebTarget target, Metrics metrics) {
        this._target = target;
        this._metrics = metrics;
        Preconditions.checkNotNull(this._target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SegmentChange fetch(String segmentName, long since) {
        long start = System.currentTimeMillis();
        try {
            Response response = this._target.path(segmentName).queryParam(SINCE, since).request("application/json").acceptEncoding("gzip").get();
            if (response.getStatus() != 200) {
                _log.error("Response status was: " + response.getStatus());
                this._metrics.count("segmentChangeFetcher.status." + response.getStatus(), 1L);
                SegmentChange segmentChange = this.noChange(segmentName, since);
                return segmentChange;
            }
            SegmentChange result = null;
            try {
                result = response.readEntity(SegmentChange.class);
            }
            catch (Throwable t) {
                _log.error("Problem reading entity: " + response.getStatus(), t);
                this._metrics.count("segmentChangeFetcher.exception", 1L);
                result = this.noChange(segmentName, since);
            }
            SegmentChange segmentChange = result;
            return segmentChange;
        }
        finally {
            this._metrics.time("segmentChangeFetcher.time", System.currentTimeMillis() - start);
        }
    }

    private SegmentChange noChange(String segmentName, long since) {
        return SegmentChange.builder().till(since).since(since).name(segmentName).build();
    }
}

