/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import com.google.common.base.Preconditions;
import io.codigo.dtos.SplitChange;
import io.split.engine.experiments.SplitChangeFetcher;
import io.split.engine.metrics.Metrics;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpSplitChangeFetcher
implements SplitChangeFetcher {
    private static final Logger _log = LoggerFactory.getLogger(HttpSplitChangeFetcher.class);
    private static final String PREFIX = "splitChangeFetcher";
    private final WebTarget _target;
    private static final String SINCE = "since";
    private final Metrics _metrics;

    public static HttpSplitChangeFetcher create(WebTarget root, Metrics metrics) {
        return new HttpSplitChangeFetcher(root.path("splitChanges"), metrics);
    }

    private HttpSplitChangeFetcher(WebTarget target, Metrics metrics) {
        this._target = target;
        this._metrics = metrics;
        Preconditions.checkNotNull(this._target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SplitChange fetch(long since) {
        long start = System.currentTimeMillis();
        try {
            Response response = this._target.queryParam(SINCE, since).request("application/json").acceptEncoding("gzip").get();
            if (response.getStatus() != 200) {
                _log.error("Response status was: " + response.getStatus());
                this._metrics.count("splitChangeFetcher.status." + response.getStatus(), 1L);
                SplitChange splitChange = this.noChange(since);
                return splitChange;
            }
            SplitChange result = null;
            try {
                result = response.readEntity(SplitChange.class);
            }
            catch (Throwable t) {
                _log.error("Problem reading entity: " + response.getStatus(), t);
                this._metrics.count("splitChangeFetcher.exception", 1L);
                result = this.noChange(since);
            }
            SplitChange splitChange = result;
            return splitChange;
        }
        finally {
            this._metrics.time("splitChangeFetcher.time", System.currentTimeMillis() - start);
        }
    }

    private SplitChange noChange(long since) {
        return SplitChange.builder().till(since).since(since).build();
    }
}

