/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import com.google.common.base.Preconditions;
import io.split.client.SplitClient;
import io.split.engine.experiments.ParsedCondition;
import io.split.engine.experiments.ParsedSplit;
import io.split.engine.experiments.SplitFetcher;
import io.split.engine.impressions.TreatmentLog;
import io.split.engine.metrics.Metrics;
import io.split.engine.splitter.Splitter;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SplitClientImpl
implements SplitClient {
    private static final Logger _log = LoggerFactory.getLogger(SplitClientImpl.class);
    private final SplitFetcher _splitFetcher;
    private final TreatmentLog _treatmentLog;
    private final Metrics _metrics;

    public SplitClientImpl(SplitFetcher splitFetcher, TreatmentLog treatmentLog, Metrics metrics) {
        this._splitFetcher = splitFetcher;
        this._treatmentLog = treatmentLog;
        this._metrics = metrics;
        Preconditions.checkNotNull(this._splitFetcher);
        Preconditions.checkNotNull(this._treatmentLog);
    }

    @Override
    public String getTreatment(String id, String feature) {
        return this.getTreatment(id, feature, Collections.emptyMap());
    }

    private String getTreatment(String id, String feature, Map<String, Object> attributes) {
        try {
            if (id == null) {
                return "control";
            }
            if (feature == null) {
                _log.warn("feature was null for id: " + id);
                return "control";
            }
            long start = System.currentTimeMillis();
            String result = this.getTreatmentWithoutExceptionHandling(id, feature, attributes);
            this.recordStats(id, feature, start, result, "sdk.getTreatment");
            return result;
        }
        catch (Throwable t) {
            try {
                _log.error("Exception", t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return "control";
        }
    }

    private void recordStats(String id, String feature, long start, String result, String operation) {
        try {
            this._treatmentLog.log(id, feature, result, System.currentTimeMillis());
            this._metrics.time(operation, System.currentTimeMillis() - start);
        }
        catch (Throwable t) {
            _log.error("Exception", t);
        }
    }

    private String getTreatmentWithoutExceptionHandling(String id, String feature, Map<String, Object> attributes) {
        ParsedSplit experiment = this._splitFetcher.fetch(feature);
        if (experiment == null) {
            return "control";
        }
        return this.getTreatment(id, experiment, attributes);
    }

    private String getTreatment(String userId, ParsedSplit experiment, Map<String, Object> attributes) {
        if (experiment.killed()) {
            return experiment.defaultTreatment();
        }
        for (ParsedCondition parsedCondition : experiment.matcherAndSplits()) {
            if (!parsedCondition.matcher().match(userId, attributes)) continue;
            return Splitter.getTreatment(userId, experiment.seed(), parsedCondition.partitions());
        }
        return experiment.defaultTreatment();
    }
}

