/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.experiments;

import com.google.common.collect.ImmutableList;
import io.split.engine.experiments.ParsedCondition;
import java.util.List;

public class ParsedSplit {
    private final String _feature;
    private final int _seed;
    private final boolean _killed;
    private final String _defaultTreatment;
    private final ImmutableList<ParsedCondition> _matcherAndSplits;

    public ParsedSplit(String feature, int seed, boolean killed, String defaultTreatment, List<ParsedCondition> matcherAndSplits) {
        this._feature = feature;
        this._seed = seed;
        this._killed = killed;
        this._defaultTreatment = defaultTreatment;
        this._matcherAndSplits = ImmutableList.copyOf(matcherAndSplits);
        if (this._defaultTreatment == null) {
            throw new IllegalArgumentException("DefaultTreatment is null");
        }
    }

    public String feature() {
        return this._feature;
    }

    public int seed() {
        return this._seed;
    }

    public boolean killed() {
        return this._killed;
    }

    public String defaultTreatment() {
        return this._defaultTreatment;
    }

    public List<ParsedCondition> matcherAndSplits() {
        return this._matcherAndSplits;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this._feature.hashCode();
        result = 31 * result + Long.hashCode(this._seed);
        result = 31 * result + Boolean.hashCode(this._killed);
        result = 31 * result + this._defaultTreatment.hashCode();
        result = 31 * result + this._matcherAndSplits.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ParsedSplit)) {
            return false;
        }
        ParsedSplit other = (ParsedSplit)obj;
        return this._feature.equals(other._feature) && this._seed == other._seed && this._killed == other._killed && this._defaultTreatment.equals(other._defaultTreatment) && this._matcherAndSplits.equals(other._matcherAndSplits);
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("name:");
        bldr.append(this._feature);
        bldr.append(", seed:");
        bldr.append(this._seed);
        bldr.append(", killed:");
        bldr.append(this._killed);
        bldr.append(", default treatment:");
        bldr.append(this._defaultTreatment);
        bldr.append(", matcherAndSplits:");
        bldr.append(this._matcherAndSplits);
        return bldr.toString();
    }
}

