/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.experiments;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.codigo.dtos.Condition;
import io.codigo.dtos.Matcher;
import io.codigo.dtos.MatcherGroup;
import io.codigo.dtos.Partition;
import io.codigo.dtos.Split;
import io.codigo.models.Status;
import io.split.engine.experiments.ParsedCondition;
import io.split.engine.experiments.ParsedSplit;
import io.split.engine.matchers.AllKeysMatcher;
import io.split.engine.matchers.AttributeMatcher;
import io.split.engine.matchers.BetweenMatcher;
import io.split.engine.matchers.CombiningMatcher;
import io.split.engine.matchers.EqualToMatcher;
import io.split.engine.matchers.GreaterThanOrEqualToMatcher;
import io.split.engine.matchers.IsStringMatcher;
import io.split.engine.matchers.LessThanOrEqualToMatcher;
import io.split.engine.matchers.UserDefinedSegmentMatcher;
import io.split.engine.matchers.WhitelistMatcher;
import io.split.engine.segments.Segment;
import io.split.engine.segments.SegmentFetcher;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SplitParser {
    private static final Logger _log = LoggerFactory.getLogger(SplitParser.class);
    private SegmentFetcher _segmentFetcher;

    public SplitParser(SegmentFetcher segmentFetcher) {
        this._segmentFetcher = segmentFetcher;
        Preconditions.checkNotNull(this._segmentFetcher);
    }

    public ParsedSplit parse(Split split) {
        try {
            return this.parseWithoutExceptionHandling(split);
        }
        catch (Throwable t) {
            _log.error("Could not parse split: " + split, t);
            return null;
        }
    }

    private ParsedSplit parseWithoutExceptionHandling(Split split) {
        if (split.status() != Status.ACTIVE) {
            return null;
        }
        ArrayList<ParsedCondition> parsedConditionList = Lists.newArrayList();
        for (Condition condition : split.conditions()) {
            ImmutableList<Partition> partitions = condition.partitions();
            CombiningMatcher matcher = this.toMatcher(condition.matcherGroup());
            parsedConditionList.add(new ParsedCondition(matcher, partitions));
        }
        return new ParsedSplit(split.name(), split.seed(), split.killed(), split.defaultTreatment(), parsedConditionList);
    }

    private CombiningMatcher toMatcher(MatcherGroup matcherGroup) {
        ImmutableList<Matcher> matchers = matcherGroup.matchers();
        Preconditions.checkArgument(!matchers.isEmpty());
        ArrayList<AttributeMatcher> toCombine = Lists.newArrayList();
        for (Matcher matcher : matchers) {
            toCombine.add(this.toMatcher(matcher));
        }
        return new CombiningMatcher(matcherGroup.combiner(), toCombine);
    }

    private AttributeMatcher toMatcher(Matcher matcher) {
        io.split.engine.matchers.Matcher delegate = null;
        switch (matcher.matcherType()) {
            case ALL_KEYS: {
                delegate = new AllKeysMatcher();
                break;
            }
            case IN_SEGMENT: {
                Preconditions.checkNotNull(matcher.userDefinedSegmentMatcherData());
                Segment segment = this._segmentFetcher.segment(matcher.userDefinedSegmentMatcherData().segmentName());
                delegate = new UserDefinedSegmentMatcher(segment);
                break;
            }
            case WHITELIST: {
                Preconditions.checkNotNull(matcher.whitelistMatcherData());
                delegate = new WhitelistMatcher(matcher.whitelistMatcherData().whitelist());
                break;
            }
            case EQUAL_TO: {
                Preconditions.checkNotNull(matcher.unaryNumericMatcherData());
                delegate = new EqualToMatcher(matcher.unaryNumericMatcherData().value());
                break;
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                Preconditions.checkNotNull(matcher.unaryNumericMatcherData());
                delegate = new GreaterThanOrEqualToMatcher(matcher.unaryNumericMatcherData().value());
                break;
            }
            case LESS_THAN_OR_EQUAL_TO: {
                Preconditions.checkNotNull(matcher.unaryNumericMatcherData());
                delegate = new LessThanOrEqualToMatcher(matcher.unaryNumericMatcherData().value());
                break;
            }
            case BETWEEN: {
                Preconditions.checkNotNull(matcher.betweenMatcherData());
                delegate = new BetweenMatcher(matcher.betweenMatcherData().start(), matcher.betweenMatcherData().end());
                break;
            }
            case IS_STRING: {
                Preconditions.checkNotNull(matcher.unaryStringMatcherData());
                delegate = new IsStringMatcher(matcher.unaryStringMatcherData().value());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown matcher type: " + (Object)((Object)matcher.matcherType()));
            }
        }
        Preconditions.checkNotNull(delegate, "We were not able to create a matcher for: " + (Object)((Object)matcher.matcherType()));
        String attribute = null;
        if (matcher.keySelector() != null && matcher.keySelector().attribute() != null) {
            attribute = matcher.keySelector().attribute();
        }
        boolean negate = matcher.negate();
        return new AttributeMatcher(attribute, delegate, negate);
    }
}

