/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.matchers;

import com.google.common.base.Preconditions;
import io.split.engine.matchers.Matcher;

public class IsStringMatcher
implements Matcher {
    private final String _value;

    public IsStringMatcher(String value) {
        this._value = value;
        Preconditions.checkNotNull(this._value);
    }

    @Override
    public boolean match(Object key) {
        if (key == null) {
            return false;
        }
        if (!(key instanceof CharSequence)) {
            return false;
        }
        String keyAsString = key.toString();
        return keyAsString.equals(this._value);
    }

    public String toString() {
        return this._value;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this._value.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IsStringMatcher)) {
            return false;
        }
        IsStringMatcher other = (IsStringMatcher)obj;
        return this._value.equals(other._value);
    }
}

