/*
 * Decompiled with CFR 0.152.
 */
package io.codigo.dtos;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.codigo.dtos.Condition;
import io.codigo.dtos.Split;
import io.codigo.models.Status;
import java.util.List;
import javax.annotation.Nullable;

final class AutoValue_Split
extends Split {
    private final String orgId;
    private final String environment;
    private final String trafficTypeId;
    private final String trafficTypeName;
    private final String name;
    private final int seed;
    private final Status status;
    private final boolean killed;
    private final String defaultTreatment;
    private final ImmutableList<Condition> conditions;

    private AutoValue_Split(@Nullable String orgId, @Nullable String environment, @Nullable String trafficTypeId, @Nullable String trafficTypeName, String name, int seed, Status status, boolean killed, String defaultTreatment, ImmutableList<Condition> conditions) {
        this.orgId = orgId;
        this.environment = environment;
        this.trafficTypeId = trafficTypeId;
        this.trafficTypeName = trafficTypeName;
        if (name == null) {
            throw new NullPointerException("Null name");
        }
        this.name = name;
        this.seed = seed;
        if (status == null) {
            throw new NullPointerException("Null status");
        }
        this.status = status;
        this.killed = killed;
        if (defaultTreatment == null) {
            throw new NullPointerException("Null defaultTreatment");
        }
        this.defaultTreatment = defaultTreatment;
        if (conditions == null) {
            throw new NullPointerException("Null conditions");
        }
        this.conditions = conditions;
    }

    @Override
    @Nullable
    @JsonProperty
    public String orgId() {
        return this.orgId;
    }

    @Override
    @Nullable
    @JsonProperty
    public String environment() {
        return this.environment;
    }

    @Override
    @Nullable
    @JsonProperty
    public String trafficTypeId() {
        return this.trafficTypeId;
    }

    @Override
    @Nullable
    @JsonProperty
    public String trafficTypeName() {
        return this.trafficTypeName;
    }

    @Override
    @JsonProperty
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    public int seed() {
        return this.seed;
    }

    @Override
    @JsonProperty
    public Status status() {
        return this.status;
    }

    @Override
    @JsonProperty
    public boolean killed() {
        return this.killed;
    }

    @Override
    @JsonProperty
    public String defaultTreatment() {
        return this.defaultTreatment;
    }

    @Override
    @JsonProperty
    public ImmutableList<Condition> conditions() {
        return this.conditions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Split) {
            Split that = (Split)o;
            return (this.orgId == null ? that.orgId() == null : this.orgId.equals(that.orgId())) && (this.environment == null ? that.environment() == null : this.environment.equals(that.environment())) && (this.trafficTypeId == null ? that.trafficTypeId() == null : this.trafficTypeId.equals(that.trafficTypeId())) && (this.trafficTypeName == null ? that.trafficTypeName() == null : this.trafficTypeName.equals(that.trafficTypeName())) && this.name.equals(that.name()) && this.seed == that.seed() && this.status.equals((Object)that.status()) && this.killed == that.killed() && this.defaultTreatment.equals(that.defaultTreatment()) && this.conditions.equals(that.conditions());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.orgId == null ? 0 : this.orgId.hashCode();
        h *= 1000003;
        h ^= this.environment == null ? 0 : this.environment.hashCode();
        h *= 1000003;
        h ^= this.trafficTypeId == null ? 0 : this.trafficTypeId.hashCode();
        h *= 1000003;
        h ^= this.trafficTypeName == null ? 0 : this.trafficTypeName.hashCode();
        h *= 1000003;
        h ^= this.name.hashCode();
        h *= 1000003;
        h ^= this.seed;
        h *= 1000003;
        h ^= this.status.hashCode();
        h *= 1000003;
        h ^= this.killed ? 1231 : 1237;
        h *= 1000003;
        h ^= this.defaultTreatment.hashCode();
        h *= 1000003;
        return h ^= this.conditions.hashCode();
    }

    static final class Builder
    extends Split.Builder {
        private String orgId;
        private String environment;
        private String trafficTypeId;
        private String trafficTypeName;
        private String name;
        private Integer seed;
        private Status status;
        private Boolean killed;
        private String defaultTreatment;
        private ImmutableList<Condition> conditions;

        Builder() {
        }

        Builder(Split source) {
            this.orgId = source.orgId();
            this.environment = source.environment();
            this.trafficTypeId = source.trafficTypeId();
            this.trafficTypeName = source.trafficTypeName();
            this.name = source.name();
            this.seed = source.seed();
            this.status = source.status();
            this.killed = source.killed();
            this.defaultTreatment = source.defaultTreatment();
            this.conditions = source.conditions();
        }

        @Override
        public Split.Builder orgId(String orgId) {
            this.orgId = orgId;
            return this;
        }

        @Override
        public Split.Builder environment(String environment) {
            this.environment = environment;
            return this;
        }

        @Override
        public Split.Builder trafficTypeId(String trafficTypeId) {
            this.trafficTypeId = trafficTypeId;
            return this;
        }

        @Override
        public Split.Builder trafficTypeName(String trafficTypeName) {
            this.trafficTypeName = trafficTypeName;
            return this;
        }

        @Override
        public Split.Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Split.Builder seed(int seed) {
            this.seed = seed;
            return this;
        }

        @Override
        public Split.Builder status(Status status) {
            this.status = status;
            return this;
        }

        @Override
        public Split.Builder killed(boolean killed) {
            this.killed = killed;
            return this;
        }

        @Override
        public Split.Builder defaultTreatment(String defaultTreatment) {
            this.defaultTreatment = defaultTreatment;
            return this;
        }

        @Override
        public Split.Builder conditions(List<Condition> conditions) {
            this.conditions = ImmutableList.copyOf(conditions);
            return this;
        }

        @Override
        public Split build() {
            String missing = "";
            if (this.name == null) {
                missing = missing + " name";
            }
            if (this.seed == null) {
                missing = missing + " seed";
            }
            if (this.status == null) {
                missing = missing + " status";
            }
            if (this.killed == null) {
                missing = missing + " killed";
            }
            if (this.defaultTreatment == null) {
                missing = missing + " defaultTreatment";
            }
            if (this.conditions == null) {
                missing = missing + " conditions";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_Split(this.orgId, this.environment, this.trafficTypeId, this.trafficTypeName, this.name, this.seed, this.status, this.killed, this.defaultTreatment, this.conditions);
        }
    }
}

