/*
 * Decompiled with CFR 0.152.
 */
package io.codigo.dtos;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.collect.ImmutableList;
import io.codigo.dtos.AutoValue_Split;
import io.codigo.dtos.Condition;
import io.codigo.models.Status;
import java.util.List;
import javax.annotation.Nullable;

@JsonDeserialize(builder=AutoValue_Split.Builder.class)
public abstract class Split {
    public static Builder builder(Split split) {
        return new AutoValue_Split.Builder(split);
    }

    public static Builder builder() {
        return new AutoValue_Split.Builder().killed(false);
    }

    Split() {
    }

    @Nullable
    @JsonProperty
    public abstract String orgId();

    @Nullable
    @JsonProperty
    public abstract String environment();

    @Nullable
    @JsonProperty
    public abstract String trafficTypeId();

    @Nullable
    @JsonProperty
    public abstract String trafficTypeName();

    @JsonProperty
    public abstract String name();

    @JsonProperty
    public abstract int seed();

    @JsonProperty
    public abstract Status status();

    @JsonProperty
    public abstract boolean killed();

    @JsonProperty
    public abstract String defaultTreatment();

    @JsonProperty
    public abstract ImmutableList<Condition> conditions();

    public final String toString() {
        if (this.conditions().isEmpty()) {
            return "No Definition";
        }
        StringBuilder bldr = new StringBuilder();
        for (int i = 0; i < this.conditions().size(); ++i) {
            if (i != 0) {
                bldr.append(" else ");
            }
            bldr.append("if ");
            bldr.append(this.conditions().get(i));
        }
        return bldr.toString();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static abstract class Builder {
        @Deprecated
        public abstract Builder orgId(String var1);

        @Deprecated
        public abstract Builder environment(String var1);

        @Deprecated
        public abstract Builder trafficTypeName(String var1);

        @Deprecated
        public abstract Builder trafficTypeId(String var1);

        public abstract Builder name(String var1);

        public abstract Builder seed(int var1);

        public abstract Builder status(Status var1);

        public abstract Builder killed(boolean var1);

        public abstract Builder defaultTreatment(String var1);

        public abstract Builder conditions(List<Condition> var1);

        public abstract Split build();
    }
}

