/*
 * Decompiled with CFR 0.152.
 */
package io.split.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.split.api.GaugeDTO;
import java.util.Map;
import javax.annotation.Nullable;

final class AutoValue_GaugeDTO
extends GaugeDTO {
    private final String name;
    private final double value;
    private final Map<String, String> properties;

    private AutoValue_GaugeDTO(String name, double value, @Nullable Map<String, String> properties) {
        if (name == null) {
            throw new NullPointerException("Null name");
        }
        this.name = name;
        this.value = value;
        this.properties = properties;
    }

    @Override
    @JsonProperty
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    public double value() {
        return this.value;
    }

    @Override
    @Nullable
    @JsonProperty
    public Map<String, String> properties() {
        return this.properties;
    }

    public String toString() {
        return "GaugeDTO{name=" + this.name + ", " + "value=" + this.value + ", " + "properties=" + this.properties + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GaugeDTO) {
            GaugeDTO that = (GaugeDTO)o;
            return this.name.equals(that.name()) && Double.doubleToLongBits(this.value) == Double.doubleToLongBits(that.value()) && (this.properties == null ? that.properties() == null : this.properties.equals(that.properties()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.name.hashCode();
        h *= 1000003;
        h = (int)((long)h ^ (Double.doubleToLongBits(this.value) >>> 32 ^ Double.doubleToLongBits(this.value)));
        h *= 1000003;
        return h ^= this.properties == null ? 0 : this.properties.hashCode();
    }

    static final class Builder
    extends GaugeDTO.Builder {
        private String name;
        private Double value;
        private Map<String, String> properties;

        Builder() {
        }

        Builder(GaugeDTO source) {
            this.name = source.name();
            this.value = source.value();
            this.properties = source.properties();
        }

        @Override
        public GaugeDTO.Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public GaugeDTO.Builder value(double value) {
            this.value = value;
            return this;
        }

        @Override
        public GaugeDTO.Builder properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        @Override
        public GaugeDTO build() {
            String missing = "";
            if (this.name == null) {
                missing = missing + " name";
            }
            if (this.value == null) {
                missing = missing + " value";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_GaugeDTO(this.name, this.value, this.properties);
        }
    }
}

