/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.split.client.SplitClient;
import java.util.Map;

public final class HardcodedFeatureTreatmentsSplitClient
implements SplitClient {
    private final ImmutableMap<String, String> _featureToTreatmentMap;

    public HardcodedFeatureTreatmentsSplitClient(Map<String, String> featureToTreatmentMap) {
        Preconditions.checkNotNull(featureToTreatmentMap, "featureToTreatmentMap must not be null");
        this._featureToTreatmentMap = ImmutableMap.copyOf(featureToTreatmentMap);
    }

    @Override
    public String getTreatment(String id, String feature) {
        if (id == null || feature == null) {
            return "control";
        }
        String treatment = this._featureToTreatmentMap.get(feature);
        if (treatment == null) {
            return "control";
        }
        return treatment;
    }

    @Override
    public String getTreatment(String id, String feature, Map<String, Object> attributes) {
        return this.getTreatment(id, feature);
    }

    public ImmutableMap<String, String> featureToTreatmentMap() {
        return this._featureToTreatmentMap;
    }
}

