/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

public class SplitClientConfig {
    public static final String SPLIT_SDK_VERSION = "java-1.0.1";
    private final String _endpoint;
    private final int _pollForFeatureChangesEveryNSeconds;
    private final int _pollForSegmentChangesEveryNSeconds;
    private final int _treatmentLogCacheExpireNSecondsAfterWrite;
    private final int _connectionTimeoutInMs;
    private final int _readTimeoutInMs;
    private final int _numThreadsForSegmentFetch;
    private final boolean _debugEnabled;

    public static Builder builder() {
        return new Builder();
    }

    private SplitClientConfig(String endpoint, int pollForFeatureChangesEveryNSeconds, int pollForSegmentChangesEveryNSeconds, int treatmentLogCacheExpireNSecondsAfterWrite, int connectionTimeoutInMs, int readTimeoutInMs, int numThreadsForSegmentFetch, boolean debugEnabled) {
        this._endpoint = endpoint;
        this._pollForFeatureChangesEveryNSeconds = pollForFeatureChangesEveryNSeconds;
        this._pollForSegmentChangesEveryNSeconds = pollForSegmentChangesEveryNSeconds;
        this._treatmentLogCacheExpireNSecondsAfterWrite = treatmentLogCacheExpireNSecondsAfterWrite;
        this._connectionTimeoutInMs = connectionTimeoutInMs;
        this._readTimeoutInMs = readTimeoutInMs;
        this._numThreadsForSegmentFetch = numThreadsForSegmentFetch;
        this._debugEnabled = debugEnabled;
    }

    public String endpoint() {
        return this._endpoint;
    }

    public int pollForFeatureChangesEveryNSeconds() {
        return this._pollForFeatureChangesEveryNSeconds;
    }

    public int pollForSegmentChangesEveryNSeconds() {
        return this._pollForSegmentChangesEveryNSeconds;
    }

    public int numThreadsForSegmentFetch() {
        return this._numThreadsForSegmentFetch;
    }

    public int treatmentLogCacheExpireNSecondsAfterWrite() {
        return this._treatmentLogCacheExpireNSecondsAfterWrite;
    }

    public int connectionTimeoutInMs() {
        return this._connectionTimeoutInMs;
    }

    public int readTimeoutInMs() {
        return this._readTimeoutInMs;
    }

    public boolean debugEnabled() {
        return this._debugEnabled;
    }

    public static final class Builder {
        private String _endpoint = "http://sdk.split.io/api";
        private int _pollForFeatureChangesEveryNSeconds = 60;
        private int _pollForSegmentChangesEveryNSeconds = 60;
        private int _treatmentLogCacheExpireNSecondsAfterWrite = 60;
        private int _connectionTimeOutInMs = 15000;
        private int _readTimeoutInMs = 15000;
        private int _numThreadsForSegmentFetch = 2;
        private boolean _debugEnabled = false;

        public Builder endpoint(String endpoint) {
            this._endpoint = endpoint;
            return this;
        }

        public Builder pollForFeatureChangesEveryNSeconds(int n) {
            this._pollForFeatureChangesEveryNSeconds = n;
            return this;
        }

        public Builder pollForSegmentChangesEveryNSeconds(int n) {
            this._pollForSegmentChangesEveryNSeconds = n;
            return this;
        }

        public Builder treatmentLogCacheExpireNSecondsAfterWrite(int n) {
            this._treatmentLogCacheExpireNSecondsAfterWrite = n;
            return this;
        }

        public Builder connectionTimeoutInMs(int ms) {
            this._connectionTimeOutInMs = ms;
            return this;
        }

        public Builder readTimeoutInMs(int ms) {
            this._readTimeoutInMs = ms;
            return this;
        }

        public Builder enableDebug() {
            this._debugEnabled = true;
            return this;
        }

        public Builder numThreadsForSegmentFetch(int numThreads) {
            this._numThreadsForSegmentFetch = numThreads;
            return this;
        }

        public SplitClientConfig build() {
            if (this._pollForFeatureChangesEveryNSeconds <= 0) {
                throw new IllegalArgumentException("pollForFeatureChangesEveryNSeconds must be > 0: " + this._pollForFeatureChangesEveryNSeconds);
            }
            if (this._pollForSegmentChangesEveryNSeconds <= 0) {
                throw new IllegalArgumentException("pollForSegmentChangesEveryNSeconds must be > 0: " + this._pollForSegmentChangesEveryNSeconds);
            }
            if (this._treatmentLogCacheExpireNSecondsAfterWrite <= 0) {
                throw new IllegalArgumentException("treatmentLogCacheExpireNSecondsAfterWrite must be > 0: " + this._treatmentLogCacheExpireNSecondsAfterWrite);
            }
            if (this._connectionTimeOutInMs <= 0) {
                throw new IllegalArgumentException("connectionTimeOutInMs must be > 0: " + this._connectionTimeOutInMs);
            }
            if (this._readTimeoutInMs <= 0) {
                throw new IllegalArgumentException("readTimeoutInMs must be > 0: " + this._readTimeoutInMs);
            }
            if (this._endpoint == null) {
                throw new IllegalArgumentException("endpoint must not be null");
            }
            if (this._numThreadsForSegmentFetch <= 0) {
                throw new IllegalArgumentException("Number of threads for fetching segments MUST be greater than zero");
            }
            return new SplitClientConfig(this._endpoint, this._pollForFeatureChangesEveryNSeconds, this._pollForSegmentChangesEveryNSeconds, this._treatmentLogCacheExpireNSecondsAfterWrite, this._connectionTimeOutInMs, this._readTimeoutInMs, this._numThreadsForSegmentFetch, this._debugEnabled);
        }
    }
}

