/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.HardcodedFeatureTreatmentsSplitClient;
import io.split.client.HttpSegmentChangeFetcher;
import io.split.client.HttpSplitChangeFetcher;
import io.split.client.LocalhostSplitClientBuilder;
import io.split.client.SplitClient;
import io.split.client.SplitClientConfig;
import io.split.client.SplitClientImpl;
import io.split.client.impressions.ImpressionsManager;
import io.split.client.interceptors.AddSplitHeadersFilter;
import io.split.client.interceptors.GzipDecoderResponseInterceptor;
import io.split.client.interceptors.GzipEncoderRequestInterceptor;
import io.split.client.jmx.JmxMonitor;
import io.split.client.jmx.SplitJmxMonitor;
import io.split.client.metrics.CachedMetrics;
import io.split.client.metrics.DTOMetrics;
import io.split.client.metrics.FireAndForgetMetrics;
import io.split.client.metrics.HttpMetrics;
import io.split.engine.SDKReadinessGates;
import io.split.engine.experiments.RefreshableSplitFetcherProvider;
import io.split.engine.experiments.SplitFetcher;
import io.split.engine.experiments.SplitParser;
import io.split.engine.segments.RefreshableSegmentFetcher;
import io.split.engine.segments.SegmentFetcher;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.org.apache.http.client.config.RequestConfig;
import split.org.apache.http.impl.client.CloseableHttpClient;
import split.org.apache.http.impl.client.HttpClients;
import split.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class SplitClientBuilder {
    private static final Logger _log = LoggerFactory.getLogger(SplitClientBuilder.class);
    private static Random RANDOM = new Random();
    private static AtomicReference<SplitClient> _client = new AtomicReference();
    private static Object _lock = new Object();

    public static SplitClient build(String apiToken) throws IOException, InterruptedException, TimeoutException, URISyntaxException {
        return SplitClientBuilder.build(apiToken, SplitClientConfig.builder().build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SplitClient build(String apiToken, SplitClientConfig config) throws IOException, InterruptedException, TimeoutException, URISyntaxException {
        if (_client.get() != null) {
            return _client.get();
        }
        Object object = _lock;
        synchronized (object) {
            if (_client.get() != null) {
                return _client.get();
            }
            if ("localhost".equals(apiToken)) {
                HardcodedFeatureTreatmentsSplitClient splitClient = LocalhostSplitClientBuilder.build();
                _client.set(splitClient);
                SplitClientBuilder.registerJmxMonitor(splitClient);
                return splitClient;
            }
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(config.connectionTimeout()).setSocketTimeout(config.readTimeout()).build();
            PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
            cm.setMaxTotal(20);
            cm.setDefaultMaxPerRoute(20);
            final CloseableHttpClient httpclient = HttpClients.custom().setConnectionManager(cm).setDefaultRequestConfig(requestConfig).addInterceptorLast(AddSplitHeadersFilter.instance(apiToken)).addInterceptorLast(new GzipEncoderRequestInterceptor()).addInterceptorLast(new GzipDecoderResponseInterceptor()).build();
            URI rootTarget = URI.create(config.endpoint());
            URI eventsRootTarget = URI.create(config.eventsEndpoint());
            HttpMetrics httpMetrics = HttpMetrics.create(httpclient, eventsRootTarget);
            final FireAndForgetMetrics uncachedFireAndForget = FireAndForgetMetrics.instance(httpMetrics, 2, 1000);
            SDKReadinessGates gates = new SDKReadinessGates();
            HttpSegmentChangeFetcher segmentChangeFetcher = HttpSegmentChangeFetcher.create(httpclient, rootTarget, uncachedFireAndForget);
            final RefreshableSegmentFetcher segmentFetcher = new RefreshableSegmentFetcher(segmentChangeFetcher, SplitClientBuilder.findPollingPeriod(RANDOM, config.segmentsRefreshRate()), config.numThreadsForSegmentFetch(), gates);
            SplitParser splitParser = new SplitParser(segmentFetcher);
            HttpSplitChangeFetcher splitChangeFetcher = HttpSplitChangeFetcher.create(httpclient, rootTarget, uncachedFireAndForget);
            final RefreshableSplitFetcherProvider splitFetcherProvider = new RefreshableSplitFetcherProvider(splitChangeFetcher, splitParser, SplitClientBuilder.findPollingPeriod(RANDOM, config.featuresRefreshRate()), gates);
            final ImpressionsManager treatmentLog = ImpressionsManager.instance(httpclient, config);
            CachedMetrics cachedMetrics = new CachedMetrics((DTOMetrics)httpMetrics, TimeUnit.SECONDS.toMillis(config.metricsRefreshRate()));
            final FireAndForgetMetrics cachedFireAndForgetMetrics = FireAndForgetMetrics.instance(cachedMetrics, 2, 1000);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    _log.warn("Shutdown called for split");
                    try {
                        segmentFetcher.close();
                        _log.warn("Successful shutdown of segment fetchers");
                        splitFetcherProvider.close();
                        _log.warn("Successful shutdown of splits");
                        uncachedFireAndForget.close();
                        _log.warn("Successful shutdown of metrics 1");
                        cachedFireAndForgetMetrics.close();
                        _log.warn("Successful shutdown of metrics 2");
                        ((ImpressionsManager)treatmentLog).close();
                        _log.warn("Successful shutdown of ImpressionManager");
                        httpclient.close();
                        _log.warn("Successful shutdown of httpclient");
                    }
                    catch (IOException e) {
                        _log.error("We could not shutdown split", (Throwable)e);
                    }
                }
            });
            SplitClientImpl splitClient = new SplitClientImpl(splitFetcherProvider.getFetcher(), treatmentLog, cachedFireAndForgetMetrics);
            SplitClientBuilder.registerJmxMonitor(splitClient, splitFetcherProvider.getFetcher(), segmentFetcher);
            _client.set(splitClient);
            if (config.blockUntilReady() > 0 && !gates.isSDKReady(config.blockUntilReady())) {
                throw new TimeoutException("SDK was not ready in " + config.blockUntilReady() + " milliseconds");
            }
            return splitClient;
        }
    }

    private static void registerJmxMonitor(SplitClient splitClient) {
        SplitClientBuilder.registerJmxMonitor(splitClient, null, null);
    }

    private static void registerJmxMonitor(SplitClient splitClient, SplitFetcher fetcher, SegmentFetcher segmentFetcher) {
        try {
            SplitJmxMonitor mbean = new SplitJmxMonitor(splitClient, fetcher, segmentFetcher);
            JmxMonitor.getInstance().registerMonitor("io.split.monitor", "Split", mbean);
        }
        catch (Exception e) {
            _log.warn("Unable to create JMX monitor", (Throwable)e);
        }
    }

    private static int findPollingPeriod(Random rand, int max) {
        int min = max / 2;
        return rand.nextInt(max - min + 1) + min;
    }

    public static void main(String ... args) throws IOException, InterruptedException, TimeoutException, URISyntaxException {
        if (args.length != 1) {
            System.out.println("Usage: <api_token>");
            System.exit(1);
            return;
        }
        SplitClientConfig config = SplitClientConfig.builder().endpoint("http://localhost:8081", "http://localhost:8081").enableDebug().build();
        SplitClient client = SplitClientBuilder.build(args[0], config);
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String line = reader.readLine();
            while (line != null) {
                String[] userIdAndSplit;
                if ("exit".equals(line)) {
                    System.exit(0);
                }
                if ((userIdAndSplit = line.split(" ")).length != 2) {
                    System.out.println("Could not understand command");
                } else {
                    boolean isOn = client.getTreatment(userIdAndSplit[0], userIdAndSplit[1]).equals("on");
                    System.out.println(isOn ? "on" : "off");
                }
                line = reader.readLine();
            }
        }
        catch (IOException io) {
            _log.error(io.getMessage(), (Throwable)io);
        }
    }
}

