/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.HttpSegmentChangeFetcher;
import io.split.client.HttpSplitChangeFetcher;
import io.split.client.LocalhostSplitFactoryBuilder;
import io.split.client.SplitClient;
import io.split.client.SplitClientConfig;
import io.split.client.SplitFactory;
import io.split.client.SplitFactoryImpl;
import io.split.client.impressions.ImpressionsManager;
import io.split.client.interceptors.AddSplitHeadersFilter;
import io.split.client.interceptors.GzipDecoderResponseInterceptor;
import io.split.client.interceptors.GzipEncoderRequestInterceptor;
import io.split.client.metrics.CachedMetrics;
import io.split.client.metrics.DTOMetrics;
import io.split.client.metrics.FireAndForgetMetrics;
import io.split.client.metrics.HttpMetrics;
import io.split.engine.SDKReadinessGates;
import io.split.engine.experiments.RefreshableSplitFetcherProvider;
import io.split.engine.experiments.SplitParser;
import io.split.engine.segments.RefreshableSegmentFetcher;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.org.apache.http.client.config.RequestConfig;
import split.org.apache.http.impl.client.CloseableHttpClient;
import split.org.apache.http.impl.client.HttpClients;
import split.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class SplitFactoryBuilder {
    private static final Logger _log = LoggerFactory.getLogger(SplitFactoryBuilder.class);
    private static Random RANDOM = new Random();

    public static SplitFactory build(String apiToken) throws IOException, InterruptedException, TimeoutException, URISyntaxException {
        return SplitFactoryBuilder.build(apiToken, SplitClientConfig.builder().build());
    }

    public static synchronized SplitFactory build(String apiToken, SplitClientConfig config) throws IOException, InterruptedException, TimeoutException, URISyntaxException {
        if ("localhost".equals(apiToken)) {
            return LocalhostSplitFactoryBuilder.build();
        }
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(config.connectionTimeout()).setSocketTimeout(config.readTimeout()).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(20);
        cm.setDefaultMaxPerRoute(20);
        final CloseableHttpClient httpclient = HttpClients.custom().setConnectionManager(cm).setDefaultRequestConfig(requestConfig).addInterceptorLast(AddSplitHeadersFilter.instance(apiToken)).addInterceptorLast(new GzipEncoderRequestInterceptor()).addInterceptorLast(new GzipDecoderResponseInterceptor()).build();
        URI rootTarget = URI.create(config.endpoint());
        URI eventsRootTarget = URI.create(config.eventsEndpoint());
        HttpMetrics httpMetrics = HttpMetrics.create(httpclient, eventsRootTarget);
        final FireAndForgetMetrics uncachedFireAndForget = FireAndForgetMetrics.instance(httpMetrics, 2, 1000);
        SDKReadinessGates gates = new SDKReadinessGates();
        HttpSegmentChangeFetcher segmentChangeFetcher = HttpSegmentChangeFetcher.create(httpclient, rootTarget, uncachedFireAndForget);
        final RefreshableSegmentFetcher segmentFetcher = new RefreshableSegmentFetcher(segmentChangeFetcher, SplitFactoryBuilder.findPollingPeriod(RANDOM, config.segmentsRefreshRate()), config.numThreadsForSegmentFetch(), gates);
        SplitParser splitParser = new SplitParser(segmentFetcher);
        HttpSplitChangeFetcher splitChangeFetcher = HttpSplitChangeFetcher.create(httpclient, rootTarget, uncachedFireAndForget);
        final RefreshableSplitFetcherProvider splitFetcherProvider = new RefreshableSplitFetcherProvider(splitChangeFetcher, splitParser, SplitFactoryBuilder.findPollingPeriod(RANDOM, config.featuresRefreshRate()), gates);
        final ImpressionsManager treatmentLog = ImpressionsManager.instance(httpclient, config);
        CachedMetrics cachedMetrics = new CachedMetrics((DTOMetrics)httpMetrics, TimeUnit.SECONDS.toMillis(config.metricsRefreshRate()));
        final FireAndForgetMetrics cachedFireAndForgetMetrics = FireAndForgetMetrics.instance(cachedMetrics, 2, 1000);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                _log.warn("Shutdown called for split");
                try {
                    segmentFetcher.close();
                    _log.warn("Successful shutdown of segment fetchers");
                    splitFetcherProvider.close();
                    _log.warn("Successful shutdown of splits");
                    uncachedFireAndForget.close();
                    _log.warn("Successful shutdown of metrics 1");
                    cachedFireAndForgetMetrics.close();
                    _log.warn("Successful shutdown of metrics 2");
                    ((ImpressionsManager)treatmentLog).close();
                    _log.warn("Successful shutdown of ImpressionManager");
                    httpclient.close();
                    _log.warn("Successful shutdown of httpclient");
                }
                catch (IOException e) {
                    _log.error("We could not shutdown split", (Throwable)e);
                }
            }
        });
        SplitFactoryImpl splitFactory = new SplitFactoryImpl(splitFetcherProvider.getFetcher(), treatmentLog, cachedFireAndForgetMetrics);
        if (config.blockUntilReady() > 0 && !gates.isSDKReady(config.blockUntilReady())) {
            throw new TimeoutException("SDK was not ready in " + config.blockUntilReady() + " milliseconds");
        }
        return splitFactory;
    }

    private static int findPollingPeriod(Random rand, int max) {
        int min = max / 2;
        return rand.nextInt(max - min + 1) + min;
    }

    public static void main(String ... args) throws IOException, InterruptedException, TimeoutException, URISyntaxException {
        if (args.length != 1) {
            System.out.println("Usage: <api_token>");
            System.exit(1);
            return;
        }
        SplitClientConfig config = SplitClientConfig.builder().endpoint("http://localhost:8081", "http://localhost:8081").enableDebug().build();
        SplitClient client = SplitFactoryBuilder.build(args[0], config).client();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String line = reader.readLine();
            while (line != null) {
                String[] userIdAndSplit;
                if ("exit".equals(line)) {
                    System.exit(0);
                }
                if ((userIdAndSplit = line.split(" ")).length != 2) {
                    System.out.println("Could not understand command");
                } else {
                    boolean isOn = client.getTreatment(userIdAndSplit[0], userIdAndSplit[1]).equals("on");
                    System.out.println(isOn ? "on" : "off");
                }
                line = reader.readLine();
            }
        }
        catch (IOException io) {
            _log.error(io.getMessage(), (Throwable)io);
        }
    }
}

