/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.experiments;

import io.split.client.dtos.Partition;
import io.split.engine.matchers.CombiningMatcher;
import java.util.List;

public final class ParsedCondition {
    private final CombiningMatcher _matcher;
    private final List<Partition> _partitions;

    public ParsedCondition(CombiningMatcher matcher, List<Partition> partitions) {
        this._matcher = matcher;
        this._partitions = partitions;
    }

    public CombiningMatcher matcher() {
        return this._matcher;
    }

    public List<Partition> partitions() {
        return this._partitions;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this._matcher.hashCode();
        int partitionsHashCode = 17;
        for (Partition p : this._partitions) {
            partitionsHashCode = 31 * partitionsHashCode + p.treatment.hashCode();
            partitionsHashCode = 31 * partitionsHashCode + p.size;
        }
        result = 31 * result + partitionsHashCode;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ParsedCondition)) {
            return false;
        }
        ParsedCondition other = (ParsedCondition)obj;
        boolean result = this._matcher.equals(other._matcher);
        if (!result) {
            return result;
        }
        if (this._partitions.size() != other._partitions.size()) {
            return result;
        }
        for (int i = 0; i < this._partitions.size(); ++i) {
            Partition first = this._partitions.get(i);
            Partition second = other._partitions.get(i);
            result &= first.size == second.size && first.treatment.equals(second.treatment);
        }
        return result;
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append(this._matcher);
        bldr.append(" then split ");
        boolean first = true;
        for (Partition partition : this._partitions) {
            if (!first) {
                bldr.append(',');
            }
            bldr.append(partition.size);
            bldr.append(':');
            bldr.append(partition.treatment);
            first = false;
        }
        return bldr.toString();
    }
}

