/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.experiments;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.split.client.dtos.Condition;
import io.split.client.dtos.Matcher;
import io.split.client.dtos.MatcherGroup;
import io.split.client.dtos.Partition;
import io.split.client.dtos.Split;
import io.split.client.dtos.Status;
import io.split.engine.experiments.ParsedCondition;
import io.split.engine.experiments.ParsedSplit;
import io.split.engine.matchers.AllKeysMatcher;
import io.split.engine.matchers.AttributeMatcher;
import io.split.engine.matchers.BetweenMatcher;
import io.split.engine.matchers.CombiningMatcher;
import io.split.engine.matchers.EqualToMatcher;
import io.split.engine.matchers.GreaterThanOrEqualToMatcher;
import io.split.engine.matchers.LessThanOrEqualToMatcher;
import io.split.engine.matchers.UserDefinedSegmentMatcher;
import io.split.engine.matchers.WhitelistMatcher;
import io.split.engine.segments.Segment;
import io.split.engine.segments.SegmentFetcher;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SplitParser {
    public static final int CONDITIONS_UPPER_LIMIT = 50;
    private static final Logger _log = LoggerFactory.getLogger(SplitParser.class);
    private SegmentFetcher _segmentFetcher;

    public SplitParser(SegmentFetcher segmentFetcher) {
        this._segmentFetcher = segmentFetcher;
        Preconditions.checkNotNull((Object)this._segmentFetcher);
    }

    public ParsedSplit parse(Split split) {
        try {
            return this.parseWithoutExceptionHandling(split);
        }
        catch (Throwable t) {
            _log.error("Could not parse split: " + split, t);
            return null;
        }
    }

    private ParsedSplit parseWithoutExceptionHandling(Split split) {
        if (split.status != Status.ACTIVE) {
            return null;
        }
        if (split.conditions.size() > 50) {
            _log.warn(String.format("Dropping Split name=%s due to large number of conditions(%d)", split.name, split.conditions.size()));
            return null;
        }
        ArrayList parsedConditionList = Lists.newArrayList();
        for (Condition condition : split.conditions) {
            List<Partition> partitions = condition.partitions;
            CombiningMatcher matcher = this.toMatcher(condition.matcherGroup);
            parsedConditionList.add(new ParsedCondition(matcher, partitions));
        }
        return new ParsedSplit(split.name, split.seed, split.killed, split.defaultTreatment, parsedConditionList, split.trafficTypeName, split.changeNumber);
    }

    private CombiningMatcher toMatcher(MatcherGroup matcherGroup) {
        List<Matcher> matchers = matcherGroup.matchers;
        Preconditions.checkArgument((!matchers.isEmpty() ? 1 : 0) != 0);
        ArrayList toCombine = Lists.newArrayList();
        for (Matcher matcher : matchers) {
            toCombine.add(this.toMatcher(matcher));
        }
        return new CombiningMatcher(matcherGroup.combiner, toCombine);
    }

    private AttributeMatcher toMatcher(Matcher matcher) {
        io.split.engine.matchers.Matcher delegate = null;
        switch (matcher.matcherType) {
            case ALL_KEYS: {
                delegate = new AllKeysMatcher();
                break;
            }
            case IN_SEGMENT: {
                Preconditions.checkNotNull((Object)matcher.userDefinedSegmentMatcherData);
                Segment segment = this._segmentFetcher.segment(matcher.userDefinedSegmentMatcherData.segmentName);
                delegate = new UserDefinedSegmentMatcher(segment);
                break;
            }
            case WHITELIST: {
                Preconditions.checkNotNull((Object)matcher.whitelistMatcherData);
                delegate = new WhitelistMatcher(matcher.whitelistMatcherData.whitelist);
                break;
            }
            case EQUAL_TO: {
                Preconditions.checkNotNull((Object)matcher.unaryNumericMatcherData);
                delegate = new EqualToMatcher(matcher.unaryNumericMatcherData.value, matcher.unaryNumericMatcherData.dataType);
                break;
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                Preconditions.checkNotNull((Object)matcher.unaryNumericMatcherData);
                delegate = new GreaterThanOrEqualToMatcher(matcher.unaryNumericMatcherData.value, matcher.unaryNumericMatcherData.dataType);
                break;
            }
            case LESS_THAN_OR_EQUAL_TO: {
                Preconditions.checkNotNull((Object)matcher.unaryNumericMatcherData);
                delegate = new LessThanOrEqualToMatcher(matcher.unaryNumericMatcherData.value, matcher.unaryNumericMatcherData.dataType);
                break;
            }
            case BETWEEN: {
                Preconditions.checkNotNull((Object)matcher.betweenMatcherData);
                delegate = new BetweenMatcher(matcher.betweenMatcherData.start, matcher.betweenMatcherData.end, matcher.betweenMatcherData.dataType);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown matcher type: " + (Object)((Object)matcher.matcherType));
            }
        }
        Preconditions.checkNotNull((Object)delegate, (Object)("We were not able to create a matcher for: " + (Object)((Object)matcher.matcherType)));
        String attribute = null;
        if (matcher.keySelector != null && matcher.keySelector.attribute != null) {
            attribute = matcher.keySelector.attribute;
        }
        boolean negate = matcher.negate;
        return new AttributeMatcher(attribute, delegate, negate);
    }
}

