/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import com.google.common.base.Preconditions;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.split.client.dtos.KeyImpression;
import io.split.client.dtos.TestImpressions;
import io.split.client.utils.Utils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.org.apache.http.client.methods.CloseableHttpResponse;
import split.org.apache.http.client.methods.HttpPost;
import split.org.apache.http.client.utils.URIBuilder;
import split.org.apache.http.entity.StringEntity;
import split.org.apache.http.impl.client.CloseableHttpClient;

public final class CachedTreatmentLogRemovalListener
implements RemovalListener<String, List<KeyImpression>> {
    private static final Logger _log = LoggerFactory.getLogger(CachedTreatmentLogRemovalListener.class);
    private final CloseableHttpClient _client;
    private final URI _target;

    public static CachedTreatmentLogRemovalListener create(CloseableHttpClient client, URI root) throws URISyntaxException {
        return new CachedTreatmentLogRemovalListener(client, new URIBuilder(root).setPath("/api/testImpressions").build());
    }

    private CachedTreatmentLogRemovalListener(CloseableHttpClient client, URI target) {
        this._client = client;
        this._target = target;
        Preconditions.checkNotNull((Object)this._client);
        Preconditions.checkNotNull((Object)this._target);
    }

    public void onRemoval(RemovalNotification<String, List<KeyImpression>> removalNotification) {
        String test = (String)removalNotification.getKey();
        List keys = (List)removalNotification.getValue();
        if (keys.isEmpty()) {
            _log.info("No impressions to report: " + test);
            return;
        }
        HashSet keysSeen = Sets.newHashSet();
        ArrayList filtered = Lists.newArrayList();
        for (int i = keys.size() - 1; i >= 0; --i) {
            KeyImpression keyImpression = (KeyImpression)keys.get(i);
            if (keysSeen.contains(keyImpression.keyName)) continue;
            keysSeen.add(keyImpression.keyName);
            filtered.add(keyImpression);
        }
        if (filtered.isEmpty()) {
            _log.info("No impressions to report post filtering: " + test);
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Filteration: " + filtered.size() + " left from " + keys.size());
        }
        TestImpressions testImpressionsDTO = new TestImpressions();
        testImpressionsDTO.testName = test;
        testImpressionsDTO.keyImpressions = filtered;
        this.post(testImpressionsDTO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void post(TestImpressions dto) {
        CloseableHttpResponse response;
        block5: {
            response = null;
            try {
                StringEntity entity = Utils.toJsonEntity(dto);
                HttpPost request = new HttpPost(this._target);
                request.setEntity(entity);
                response = this._client.execute(request);
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) break block5;
                _log.warn("Response status was: " + status);
            }
            catch (Throwable t) {
                try {
                    _log.warn("Exception when posting impressions" + dto, t);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    Utils.forceClose(response);
                }
            }
        }
        Utils.forceClose(response);
    }
}

