/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.interceptors;

import java.io.IOException;
import split.org.apache.http.Header;
import split.org.apache.http.HeaderElement;
import split.org.apache.http.HttpEntity;
import split.org.apache.http.HttpException;
import split.org.apache.http.HttpResponse;
import split.org.apache.http.HttpResponseInterceptor;
import split.org.apache.http.client.entity.GzipDecompressingEntity;
import split.org.apache.http.protocol.HttpContext;

public class GzipDecoderResponseInterceptor
implements HttpResponseInterceptor {
    @Override
    public void process(HttpResponse response, HttpContext httpContext) throws HttpException, IOException {
        Header ceheader;
        HttpEntity entity = response.getEntity();
        if (entity != null && (ceheader = entity.getContentEncoding()) != null) {
            HeaderElement[] codecs = ceheader.getElements();
            for (int i = 0; i < codecs.length; ++i) {
                if (!codecs[i].getName().equalsIgnoreCase("gzip")) continue;
                response.setEntity(new GzipDecompressingEntity(response.getEntity()));
                return;
            }
        }
    }
}

