/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.impressions;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.collect.Lists;
import io.split.client.dtos.KeyImpression;
import io.split.engine.impressions.TreatmentLog;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class CachedTreatmentLog
implements TreatmentLog {
    private final Cache<String, List<KeyImpression>> _cache;
    private final int _maximumNumberOfKeysToCachePerTest;

    public static CachedTreatmentLog instance(long expireAfterWriteSeconds, int maxNumOfKeysToCachePerTest, RemovalListener<String, List<KeyImpression>> removalListener) {
        Cache cache = CacheBuilder.newBuilder().expireAfterWrite(expireAfterWriteSeconds, TimeUnit.SECONDS).removalListener(removalListener).build();
        return new CachedTreatmentLog(cache, maxNumOfKeysToCachePerTest);
    }

    private CachedTreatmentLog(Cache cache, int maximumNumberOfKeysToCachePerTest) {
        this._maximumNumberOfKeysToCachePerTest = maximumNumberOfKeysToCachePerTest;
        this._cache = cache;
        Preconditions.checkNotNull(this._cache);
        Preconditions.checkArgument((this._maximumNumberOfKeysToCachePerTest >= 0 ? 1 : 0) != 0, (Object)"MaximumNumberOfKeysToCachePerTest cannot be negative");
    }

    @Override
    public void log(String id, String feature, String treatment, long time) {
        if (id == null || feature == null || treatment == null || time < 0L) {
            return;
        }
        List impressions = (List)this._cache.getIfPresent((Object)feature);
        if (impressions == null) {
            impressions = Collections.synchronizedList(Lists.newArrayListWithCapacity((int)this._maximumNumberOfKeysToCachePerTest));
            impressions.add(this.keyImpression(id, treatment, time));
            this._cache.put((Object)feature, impressions);
        } else if (impressions.size() >= this._maximumNumberOfKeysToCachePerTest) {
            this._cache.invalidate((Object)feature);
            impressions = Collections.synchronizedList(Lists.newArrayListWithCapacity((int)this._maximumNumberOfKeysToCachePerTest));
            impressions.add(this.keyImpression(id, treatment, time));
            this._cache.put((Object)feature, impressions);
        } else {
            impressions.add(this.keyImpression(id, treatment, time));
        }
    }

    private KeyImpression keyImpression(String key, String treatment, long time) {
        KeyImpression result = new KeyImpression();
        result.keyName = key;
        result.treatment = treatment;
        result.time = time;
        return result;
    }
}

