/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.experiments;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.split.engine.SDKReadinessGates;
import io.split.engine.experiments.RefreshableSplitFetcher;
import io.split.engine.experiments.SplitChangeFetcher;
import io.split.engine.experiments.SplitParser;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshableSplitFetcherProvider
implements Closeable {
    private static final Logger _log = LoggerFactory.getLogger(RefreshableSplitFetcherProvider.class);
    private final SplitParser _splitParser;
    private final SplitChangeFetcher _splitChangeFetcher;
    private final AtomicLong _refreshEveryNSeconds;
    private final AtomicReference<RefreshableSplitFetcher> _splitFetcher = new AtomicReference();
    private final SDKReadinessGates _gates;
    private final AtomicReference<ScheduledExecutorService> _executorService = new AtomicReference();
    private final Object _lock = new Object();

    public RefreshableSplitFetcherProvider(SplitChangeFetcher splitChangeFetcher, SplitParser splitParser, long refreshEveryNSeconds, SDKReadinessGates sdkBuildBlocker) {
        this._splitChangeFetcher = splitChangeFetcher;
        Preconditions.checkNotNull((Object)this._splitChangeFetcher);
        this._splitParser = splitParser;
        Preconditions.checkNotNull((Object)this._splitParser);
        Preconditions.checkArgument((refreshEveryNSeconds >= 0L ? 1 : 0) != 0);
        this._refreshEveryNSeconds = new AtomicLong(refreshEveryNSeconds);
        this._gates = sdkBuildBlocker;
        Preconditions.checkNotNull((Object)this._gates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefreshableSplitFetcher getFetcher() {
        if (this._splitFetcher.get() != null) {
            return this._splitFetcher.get();
        }
        Object object = this._lock;
        synchronized (object) {
            if (this._splitFetcher.get() != null) {
                return this._splitFetcher.get();
            }
            RefreshableSplitFetcher splitFetcher = new RefreshableSplitFetcher(this._splitChangeFetcher, this._splitParser, this._gates);
            ThreadFactoryBuilder threadFactoryBuilder = new ThreadFactoryBuilder();
            threadFactoryBuilder.setDaemon(true);
            threadFactoryBuilder.setNameFormat("split-splitFetcher-%d");
            ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(threadFactoryBuilder.build());
            scheduledExecutorService.scheduleWithFixedDelay(splitFetcher, 0L, this._refreshEveryNSeconds.get(), TimeUnit.SECONDS);
            this._executorService.set(scheduledExecutorService);
            this._splitFetcher.set(splitFetcher);
            return splitFetcher;
        }
    }

    @Override
    public void close() {
        if (this._executorService.get() == null) {
            return;
        }
        ScheduledExecutorService scheduledExecutorService = this._executorService.get();
        if (scheduledExecutorService.isShutdown()) {
            return;
        }
        scheduledExecutorService.shutdown();
        try {
            if (!scheduledExecutorService.awaitTermination(2L, TimeUnit.SECONDS)) {
                _log.warn("Executor did not terminate in the specified time.");
                List<Runnable> droppedTasks = scheduledExecutorService.shutdownNow();
                _log.warn("Executor was abruptly shut down. These tasks will not be executed: " + droppedTasks);
            }
        }
        catch (InterruptedException e) {
            _log.warn("Shutdown hook for split fetchers has been interrupted");
            Thread.currentThread().interrupt();
        }
    }
}

