/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import io.split.client.LocalhostSplitClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalhostSplitClientBuilder {
    private static final Logger _log = LoggerFactory.getLogger(LocalhostSplitClientBuilder.class);
    public static final String LOCALHOST = "localhost";
    public static final String FILENAME = ".split";

    public static LocalhostSplitClient build() throws IOException {
        String home = System.getProperty("user.home");
        Preconditions.checkNotNull((Object)home, (Object)"Property user.home should be set when using environment: localhost");
        return LocalhostSplitClientBuilder.build(home);
    }

    static LocalhostSplitClient build(String home) throws IOException {
        _log.info("home = " + home);
        BufferedReader reader = null;
        String fileName = home + "/" + FILENAME;
        HashMap onSplits = Maps.newHashMap();
        try {
            reader = new BufferedReader(new FileReader(new File(fileName)));
            String line = reader.readLine();
            while (line != null) {
                if (!(line = line.trim()).isEmpty() && !line.startsWith("#")) {
                    String[] feature_treatment = line.split("\\s+");
                    if (feature_treatment.length != 2) {
                        _log.info("Ignoring line since it does not have exactly two columns: " + line);
                    } else {
                        onSplits.put(feature_treatment[0], feature_treatment[1]);
                        _log.info("100% of keys will see " + feature_treatment[1] + " for " + feature_treatment[0]);
                    }
                }
                line = reader.readLine();
            }
        }
        catch (FileNotFoundException e) {
            _log.warn("There was no file named " + fileName + " found. " + "We created a split client that returns default treatments for all features for all of your users. " + "If you wish to return a specific treatment for a feature, enter the name of that feature name and " + "treatment name separated by whitespace in " + fileName + "; one pair per line. Empty lines or lines starting with '#' are considered comments", (Throwable)e);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return new LocalhostSplitClient(onSplits);
    }
}

