/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.split.client.LocalhostSplitClient;
import io.split.client.LocalhostSplitManager;
import io.split.client.SplitClient;
import io.split.client.SplitFactory;
import io.split.client.SplitManager;
import java.util.Map;

public final class LocalhostSplitFactory
implements SplitFactory {
    private final ImmutableMap<String, String> _featureToTreatmentMap;

    public LocalhostSplitFactory(Map<String, String> featureToTreatmentMap) {
        Preconditions.checkNotNull(featureToTreatmentMap, (Object)"featureToTreatmentMap must not be null");
        this._featureToTreatmentMap = ImmutableMap.copyOf(featureToTreatmentMap);
    }

    @Override
    public SplitClient client() {
        return new LocalhostSplitClient((Map<String, String>)this._featureToTreatmentMap);
    }

    @Override
    public SplitManager manager() {
        return new LocalhostSplitManager((Map<String, String>)this._featureToTreatmentMap);
    }
}

