/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.impressions;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.split.client.SplitClientConfig;
import io.split.client.dtos.KeyImpression;
import io.split.client.dtos.TestImpressions;
import io.split.client.impressions.HttpImpressionsSender;
import io.split.client.impressions.Impression;
import io.split.client.impressions.ImpressionListener;
import io.split.client.impressions.ImpressionsSender;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.org.apache.http.impl.client.CloseableHttpClient;

public class ImpressionsManager
implements ImpressionListener,
Runnable {
    private static final Logger _log = LoggerFactory.getLogger(ImpressionsManager.class);
    private final SplitClientConfig _config;
    private final CloseableHttpClient _client;
    private final BlockingQueue<KeyImpression> _queue;
    private final ScheduledExecutorService _scheduler;
    private final ImpressionsSender _impressionsSender;

    public static ImpressionsManager instance(CloseableHttpClient client, SplitClientConfig config) throws URISyntaxException {
        return new ImpressionsManager(client, config, null);
    }

    public static ImpressionsManager instanceForTest(CloseableHttpClient client, SplitClientConfig config, ImpressionsSender impressionsSender) throws URISyntaxException {
        return new ImpressionsManager(client, config, impressionsSender);
    }

    private ImpressionsManager(CloseableHttpClient client, SplitClientConfig config, ImpressionsSender impressionsSender) throws URISyntaxException {
        this._config = config;
        this._client = client;
        this._queue = new ArrayBlockingQueue<KeyImpression>(config.impressionsQueueSize());
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Split-ImpressionsManager-%d").build();
        this._scheduler = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this._scheduler.scheduleAtFixedRate(this, 10L, config.impressionsRefreshRate(), TimeUnit.SECONDS);
        this._impressionsSender = impressionsSender != null ? impressionsSender : new HttpImpressionsSender(this._client, config.eventsEndpoint());
    }

    @Override
    public void log(Impression impression) {
        try {
            KeyImpression keyImpression = this.keyImpression(impression);
            this._queue.offer(keyImpression);
        }
        catch (Exception e) {
            _log.warn("Unable to send impression to ImpressionsManager", (Throwable)e);
        }
    }

    @Override
    public void close() {
        try {
            this._scheduler.shutdown();
            this.sendImpressions();
        }
        catch (Exception e) {
            _log.warn("Unable to close ImpressionsManager", (Throwable)e);
        }
    }

    private KeyImpression keyImpression(Impression impression) {
        KeyImpression result = new KeyImpression();
        result.feature = impression.split();
        result.keyName = impression.key();
        if (impression.bucketingKey() != null && !impression.bucketingKey().equals(impression.key())) {
            result.bucketingKey = impression.bucketingKey();
        }
        result.label = impression.appliedRule();
        result.treatment = impression.treatment();
        result.time = impression.time();
        result.changeNumber = impression.changeNumber();
        return result;
    }

    @Override
    public void run() {
        this.sendImpressions();
    }

    private void sendImpressions() {
        if (this._queue.remainingCapacity() == 0) {
            _log.warn("Split SDK impressions queue is full. Impressions may have been dropped. Consider increasing capacity.");
        }
        long start = System.currentTimeMillis();
        ArrayList impressions = new ArrayList(this._queue.size());
        this._queue.drainTo(impressions);
        if (impressions.isEmpty()) {
            return;
        }
        HashMap<String, ArrayList<KeyImpression>> tests = new HashMap<String, ArrayList<KeyImpression>>();
        for (KeyImpression ki : impressions) {
            ArrayList<KeyImpression> impressionsForTest = (ArrayList<KeyImpression>)tests.get(ki.feature);
            if (impressionsForTest == null) {
                impressionsForTest = new ArrayList<KeyImpression>();
                tests.put(ki.feature, impressionsForTest);
            }
            impressionsForTest.add(ki);
        }
        ArrayList toShip = Lists.newArrayList();
        for (Map.Entry entry : tests.entrySet()) {
            String testName = (String)entry.getKey();
            List keyImpressions = (List)entry.getValue();
            TestImpressions testImpressionsDTO = new TestImpressions();
            testImpressionsDTO.testName = testName;
            testImpressionsDTO.keyImpressions = keyImpressions;
            toShip.add(testImpressionsDTO);
        }
        this._impressionsSender.post(toShip);
        if (this._config.debugEnabled()) {
            _log.info(String.format("Posting %d Split impressions took %d millis", impressions.size(), System.currentTimeMillis() - start));
        }
    }
}

