/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.splitter;

import io.split.client.dtos.Partition;
import java.util.List;

public class Splitter {
    public static String getTreatment(String key, int seed, List<Partition> partitions) {
        if (partitions.isEmpty()) {
            return "control";
        }
        if (Splitter.hundredPercentOneTreatment(partitions)) {
            return partitions.get((int)0).treatment;
        }
        return Splitter.getTreatment(Splitter.bucket(Splitter.hash(key, seed)), partitions);
    }

    public static int getBucket(String key, int seed) {
        return Splitter.bucket(Splitter.hash(key, seed));
    }

    static int hash(String key, int seed) {
        int h = 0;
        for (int i = 0; i < key.length(); ++i) {
            h = 31 * h + key.charAt(i);
        }
        return h ^ seed;
    }

    private static String getTreatment(int bucket, List<Partition> partitions) {
        int bucketsCoveredThusFar = 0;
        for (Partition partition : partitions) {
            if ((bucketsCoveredThusFar += partition.size) < bucket) continue;
            return partition.treatment;
        }
        return "control";
    }

    static int bucket(int hash) {
        return Math.abs(hash % 100) + 1;
    }

    private static boolean hundredPercentOneTreatment(List<Partition> partitions) {
        if (partitions.size() != 1) {
            return false;
        }
        return partitions.get((int)0).size == 100;
    }
}

