/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.metrics;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.split.client.dtos.Counter;
import io.split.client.dtos.Latency;
import io.split.client.metrics.DTOMetrics;
import io.split.client.utils.Utils;
import io.split.engine.metrics.Metrics;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.org.apache.http.client.methods.CloseableHttpResponse;
import split.org.apache.http.client.methods.HttpPost;
import split.org.apache.http.client.utils.URIBuilder;
import split.org.apache.http.entity.StringEntity;
import split.org.apache.http.impl.client.CloseableHttpClient;

public class HttpMetrics
implements Metrics,
DTOMetrics {
    private static final Logger _log = LoggerFactory.getLogger(HttpMetrics.class);
    private final CloseableHttpClient _client;
    private final URI _target;

    public static HttpMetrics create(CloseableHttpClient client, URI root) throws URISyntaxException {
        return new HttpMetrics(client, new URIBuilder(root).build());
    }

    public HttpMetrics(CloseableHttpClient client, URI uri) {
        this._client = client;
        this._target = uri;
        Preconditions.checkNotNull((Object)this._client);
        Preconditions.checkNotNull((Object)this._target);
    }

    @Override
    public void time(Latency dto) {
        if (dto.latencies.isEmpty()) {
            return;
        }
        try {
            this.post(new URIBuilder(this._target).setPath("/api/metrics/time").build(), dto);
        }
        catch (Throwable t) {
            _log.warn("Exception when posting metric" + dto, t);
        }
    }

    @Override
    public void count(Counter dto) {
        try {
            this.post(new URIBuilder(this._target).setPath("/api/metrics/counter").build(), dto);
        }
        catch (Throwable t) {
            _log.warn("Exception when posting metric" + dto, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void post(URI uri, Object dto) {
        CloseableHttpResponse response;
        block4: {
            response = null;
            try {
                StringEntity entity = Utils.toJsonEntity(dto);
                HttpPost request = new HttpPost(uri);
                request.setEntity(entity);
                response = this._client.execute(request);
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) break block4;
                _log.warn("Response status was: " + status);
            }
            catch (Throwable t) {
                try {
                    _log.warn("Exception when posting metric" + dto, t);
                }
                catch (Throwable throwable) {
                    Utils.forceClose(response);
                    throw throwable;
                }
                Utils.forceClose(response);
            }
        }
        Utils.forceClose(response);
    }

    @Override
    public void count(String counter, long delta) {
        try {
            Counter dto = new Counter();
            dto.name = counter;
            dto.delta = delta;
            this.count(dto);
        }
        catch (Throwable t) {
            _log.info("Could not count metric " + counter, t);
        }
    }

    @Override
    public void time(String operation, long timeInMs) {
        try {
            Latency dto = new Latency();
            dto.name = operation;
            dto.latencies = Lists.newArrayList((Object[])new Long[]{timeInMs});
            this.time(dto);
        }
        catch (Throwable t) {
            _log.info("Could not time metric " + operation, t);
        }
    }
}

