/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.EventClient;
import io.split.client.EventClientImpl;
import io.split.client.HttpSegmentChangeFetcher;
import io.split.client.HttpSplitChangeFetcher;
import io.split.client.SplitClient;
import io.split.client.SplitClientConfig;
import io.split.client.SplitClientImpl;
import io.split.client.SplitFactory;
import io.split.client.SplitManager;
import io.split.client.SplitManagerImpl;
import io.split.client.impressions.AsynchronousImpressionListener;
import io.split.client.impressions.ImpressionListener;
import io.split.client.impressions.ImpressionsManager;
import io.split.client.interceptors.AddSplitHeadersFilter;
import io.split.client.interceptors.GzipDecoderResponseInterceptor;
import io.split.client.interceptors.GzipEncoderRequestInterceptor;
import io.split.client.metrics.CachedMetrics;
import io.split.client.metrics.DTOMetrics;
import io.split.client.metrics.FireAndForgetMetrics;
import io.split.client.metrics.HttpMetrics;
import io.split.engine.SDKReadinessGates;
import io.split.engine.experiments.RefreshableSplitFetcherProvider;
import io.split.engine.experiments.SplitParser;
import io.split.engine.segments.RefreshableSegmentFetcher;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.org.apache.http.auth.AuthScope;
import split.org.apache.http.auth.UsernamePasswordCredentials;
import split.org.apache.http.client.config.RequestConfig;
import split.org.apache.http.config.Registry;
import split.org.apache.http.config.RegistryBuilder;
import split.org.apache.http.conn.socket.ConnectionSocketFactory;
import split.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import split.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import split.org.apache.http.conn.ssl.SSLContexts;
import split.org.apache.http.impl.client.BasicCredentialsProvider;
import split.org.apache.http.impl.client.CloseableHttpClient;
import split.org.apache.http.impl.client.HttpClientBuilder;
import split.org.apache.http.impl.client.HttpClients;
import split.org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import split.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class SplitFactoryImpl
implements SplitFactory {
    private static final Logger _log = LoggerFactory.getLogger(SplitFactory.class);
    private static Random RANDOM = new Random();
    private final SplitClient _client;
    private final SplitManager _manager;
    private final Runnable destroyer;
    private boolean isTerminated = false;

    public SplitFactoryImpl(String apiToken, SplitClientConfig config) throws IOException, InterruptedException, TimeoutException, URISyntaxException {
        ImpressionListener impressionListener;
        SSLContext sslContext = null;
        try {
            sslContext = SSLContexts.custom().useTLS().build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to create support for secure connection.");
        }
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1.1", "TLSv1.2"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
        Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)sslsf)).build();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(config.connectionTimeout()).setSocketTimeout(config.readTimeout()).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(registry);
        cm.setMaxTotal(20);
        cm.setDefaultMaxPerRoute(20);
        HttpClientBuilder httpClientbuilder = HttpClients.custom().setConnectionManager(cm).setDefaultRequestConfig(requestConfig).setSSLSocketFactory(sslsf).addInterceptorLast(AddSplitHeadersFilter.instance(apiToken)).addInterceptorLast(new GzipEncoderRequestInterceptor()).addInterceptorLast(new GzipDecoderResponseInterceptor());
        if (config.proxy() != null) {
            _log.info("Initializing Split SDK with proxy settings");
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(config.proxy());
            httpClientbuilder.setRoutePlanner(routePlanner);
            if (config.proxyUsername() != null && config.proxyPassword() != null) {
                _log.debug("Proxy setup using credentials");
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                AuthScope siteScope = new AuthScope(config.proxy().getHostName(), config.proxy().getPort());
                UsernamePasswordCredentials siteCreds = new UsernamePasswordCredentials(config.proxyUsername(), config.proxyPassword());
                credsProvider.setCredentials(siteScope, siteCreds);
                httpClientbuilder.setDefaultCredentialsProvider(credsProvider);
            }
        }
        final CloseableHttpClient httpclient = httpClientbuilder.build();
        URI rootTarget = URI.create(config.endpoint());
        URI eventsRootTarget = URI.create(config.eventsEndpoint());
        HttpMetrics httpMetrics = HttpMetrics.create(httpclient, eventsRootTarget);
        final FireAndForgetMetrics uncachedFireAndForget = FireAndForgetMetrics.instance(httpMetrics, 2, 1000);
        SDKReadinessGates gates = new SDKReadinessGates();
        HttpSegmentChangeFetcher segmentChangeFetcher = HttpSegmentChangeFetcher.create(httpclient, rootTarget, uncachedFireAndForget);
        final RefreshableSegmentFetcher segmentFetcher = new RefreshableSegmentFetcher(segmentChangeFetcher, SplitFactoryImpl.findPollingPeriod(RANDOM, config.segmentsRefreshRate()), config.numThreadsForSegmentFetch(), gates);
        SplitParser splitParser = new SplitParser(segmentFetcher);
        HttpSplitChangeFetcher splitChangeFetcher = HttpSplitChangeFetcher.create(httpclient, rootTarget, uncachedFireAndForget);
        final RefreshableSplitFetcherProvider splitFetcherProvider = new RefreshableSplitFetcherProvider(splitChangeFetcher, splitParser, SplitFactoryImpl.findPollingPeriod(RANDOM, config.featuresRefreshRate()), gates);
        ImpressionsManager splitImpressionListener = ImpressionsManager.instance(httpclient, config);
        if (config.impressionListener() != null) {
            AsynchronousImpressionListener wrapper = AsynchronousImpressionListener.build(config.impressionListener(), config.impressionListenerCapactity());
            ArrayList<ImpressionListener> impressionListeners = new ArrayList<ImpressionListener>();
            impressionListeners.add(splitImpressionListener);
            impressionListeners.add(wrapper);
            impressionListener = new ImpressionListener.FederatedImpressionListener(impressionListeners);
        } else {
            impressionListener = splitImpressionListener;
        }
        CachedMetrics cachedMetrics = new CachedMetrics((DTOMetrics)httpMetrics, TimeUnit.SECONDS.toMillis(config.metricsRefreshRate()));
        final FireAndForgetMetrics cachedFireAndForgetMetrics = FireAndForgetMetrics.instance(cachedMetrics, 2, 1000);
        final EventClient eventClient = EventClientImpl.create(httpclient, eventsRootTarget, config.eventsQueueSize(), config.eventFlushIntervalInMillis(), config.waitBeforeShutdown());
        this.destroyer = new Runnable(){

            @Override
            public void run() {
                _log.info("Shutdown called for split");
                try {
                    segmentFetcher.close();
                    _log.info("Successful shutdown of segment fetchers");
                    splitFetcherProvider.close();
                    _log.info("Successful shutdown of splits");
                    uncachedFireAndForget.close();
                    _log.info("Successful shutdown of metrics 1");
                    cachedFireAndForgetMetrics.close();
                    _log.info("Successful shutdown of metrics 2");
                    impressionListener.close();
                    _log.info("Successful shutdown of ImpressionListener");
                    httpclient.close();
                    _log.info("Successful shutdown of httpclient");
                    eventClient.close();
                    _log.info("Successful shutdown of httpclient");
                }
                catch (IOException e) {
                    _log.error("We could not shutdown split", (Throwable)e);
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                SplitFactoryImpl.this.destroy();
            }
        });
        this._client = new SplitClientImpl(this, splitFetcherProvider.getFetcher(), impressionListener, cachedFireAndForgetMetrics, eventClient, config);
        this._manager = new SplitManagerImpl(splitFetcherProvider.getFetcher());
        if (config.blockUntilReady() > 0 && !gates.isSDKReady(config.blockUntilReady())) {
            throw new TimeoutException("SDK was not ready in " + config.blockUntilReady() + " milliseconds");
        }
    }

    private static int findPollingPeriod(Random rand, int max) {
        int min = max / 2;
        return rand.nextInt(max - min + 1) + min;
    }

    @Override
    public SplitClient client() {
        return this._client;
    }

    @Override
    public SplitManager manager() {
        return this._manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Class<SplitFactoryImpl> clazz = SplitFactoryImpl.class;
        synchronized (SplitFactoryImpl.class) {
            if (!this.isTerminated) {
                this.destroyer.run();
                this.isTerminated = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

