/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import com.google.common.base.Preconditions;
import io.split.client.SplitAndKey;
import io.split.client.SplitClient;
import io.split.client.api.Key;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocalhostSplitClient
implements SplitClient {
    private static final Logger _log = LoggerFactory.getLogger(LocalhostSplitClient.class);
    private Map<SplitAndKey, String> _map;

    public LocalhostSplitClient(Map<SplitAndKey, String> map) {
        Preconditions.checkNotNull(map, (Object)"map must not be null");
        this._map = map;
    }

    @Override
    public String getTreatment(String key, String split) {
        if (key == null || split == null) {
            return "control";
        }
        SplitAndKey override = SplitAndKey.of(split, key);
        if (this._map.containsKey(override)) {
            return this._map.get(override);
        }
        SplitAndKey splitDefaultTreatment = SplitAndKey.of(split);
        String treatment = this._map.get(splitDefaultTreatment);
        if (treatment == null) {
            return "control";
        }
        return treatment;
    }

    @Override
    public String getTreatment(String key, String split, Map<String, Object> attributes) {
        return this.getTreatment(key, split);
    }

    @Override
    public String getTreatment(Key key, String split, Map<String, Object> attributes) {
        return this.getTreatment(key.matchingKey(), split, attributes);
    }

    public void updateFeatureToTreatmentMap(Map<SplitAndKey, String> map) {
        if (map == null) {
            _log.warn("A null map was passed as an update. Ignoring this update.");
            return;
        }
        this._map = map;
    }

    @Override
    public void destroy() {
        this._map.clear();
    }

    @Override
    public boolean track(String key, String trafficType, String eventType) {
        return false;
    }

    @Override
    public boolean track(String key, String trafficType, String eventType, double value) {
        return false;
    }

    @Override
    public void blockUntilReady() throws TimeoutException, InterruptedException {
    }
}

