/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDKReadinessGates {
    private static final Logger _log = LoggerFactory.getLogger(SDKReadinessGates.class);
    private final CountDownLatch _splitsAreReady = new CountDownLatch(1);
    private final ConcurrentMap<String, CountDownLatch> _segmentsAreReady = new ConcurrentHashMap<String, CountDownLatch>();

    public boolean isSDKReady(long milliseconds) throws InterruptedException {
        long end = System.currentTimeMillis() + milliseconds;
        long timeLeft = milliseconds;
        boolean splits = this.areSplitsReady(timeLeft);
        if (!splits) {
            return false;
        }
        timeLeft = end - System.currentTimeMillis();
        return this.areSegmentsReady(timeLeft);
    }

    public void splitsAreReady() {
        long originalCount = this._splitsAreReady.getCount();
        this._splitsAreReady.countDown();
        if (originalCount > 0L) {
            _log.info("splits are ready");
        }
    }

    public boolean registerSegment(String segmentName) throws InterruptedException {
        if (segmentName == null || segmentName.isEmpty() || this.areSplitsReady(0L)) {
            return false;
        }
        this._segmentsAreReady.putIfAbsent(segmentName, new CountDownLatch(1));
        _log.info("Registered segment: " + segmentName);
        return true;
    }

    public void segmentIsReady(String segmentName) {
        CountDownLatch cdl = (CountDownLatch)this._segmentsAreReady.get(segmentName);
        if (cdl == null) {
            return;
        }
        long originalCount = cdl.getCount();
        cdl.countDown();
        if (originalCount > 0L) {
            _log.info(segmentName + " segment is ready");
        }
    }

    public boolean isSegmentRegistered(String segmentName) {
        return this._segmentsAreReady.get(segmentName) != null;
    }

    public boolean areSegmentsReady(long milliseconds) throws InterruptedException {
        long end = System.currentTimeMillis() + milliseconds;
        long timeLeft = milliseconds;
        for (Map.Entry entry : this._segmentsAreReady.entrySet()) {
            String segmentName = (String)entry.getKey();
            CountDownLatch cdl = (CountDownLatch)entry.getValue();
            if (!cdl.await(timeLeft, TimeUnit.MILLISECONDS)) {
                _log.error(segmentName + " is not ready yet");
                return false;
            }
            timeLeft = end - System.currentTimeMillis();
        }
        return true;
    }

    public boolean areSplitsReady(long milliseconds) throws InterruptedException {
        return this._splitsAreReady.await(milliseconds, TimeUnit.MILLISECONDS);
    }
}

