/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.AbstractLocalhostSplitFile;
import io.split.client.LegacyLocalhostSplitFile;
import io.split.client.LocalhostSplit;
import io.split.client.LocalhostSplitClient;
import io.split.client.LocalhostSplitClientAndFactory;
import io.split.client.LocalhostSplitManager;
import io.split.client.SplitAndKey;
import io.split.client.SplitClient;
import io.split.client.SplitClientConfig;
import io.split.client.SplitFactory;
import io.split.client.SplitManager;
import io.split.client.YamlLocalhostSplitFile;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocalhostSplitFactory
implements SplitFactory {
    private static final Logger _log = LoggerFactory.getLogger(LocalhostSplitFactory.class);
    static final String FILENAME = ".split";
    static final String LOCALHOST = "localhost";
    private final LocalhostSplitClientAndFactory _client;
    private final LocalhostSplitManager _manager;
    private final AbstractLocalhostSplitFile _splitFile;

    public static LocalhostSplitFactory createLocalhostSplitFactory(SplitClientConfig config) throws IOException {
        String directory = System.getProperty("user.home");
        return new LocalhostSplitFactory(directory, config.splitFile());
    }

    public LocalhostSplitFactory(String directory, String file) throws IOException {
        if (file != null && !file.isEmpty() && (file.endsWith(".yaml") || file.endsWith(".yml"))) {
            this._splitFile = new YamlLocalhostSplitFile(this, "", file);
            _log.info("Starting Split in localhost mode with file at " + this._splitFile._file.getAbsolutePath());
        } else {
            this._splitFile = new LegacyLocalhostSplitFile(this, directory, FILENAME);
            _log.warn("(Deprecated) Starting Split in localhost mode using legacy file located at " + this._splitFile._file.getAbsolutePath() + "\nPlease delete this file or split.yaml location will be ignored");
        }
        Map<SplitAndKey, LocalhostSplit> splitAndKeyToTreatment = this._splitFile.readOnSplits();
        this._client = new LocalhostSplitClientAndFactory(this, new LocalhostSplitClient(splitAndKeyToTreatment));
        this._manager = LocalhostSplitManager.of(splitAndKeyToTreatment);
        this._splitFile.registerWatcher();
        this._splitFile.setDaemon(true);
        this._splitFile.start();
    }

    @Override
    public SplitClient client() {
        return this._client;
    }

    @Override
    public SplitManager manager() {
        return this._manager;
    }

    @Override
    public void destroy() {
        this._splitFile.stopThread();
    }

    @Override
    public boolean isDestroyed() {
        return this._splitFile.isStopped();
    }

    public void updateFeatureToTreatmentMap(Map<SplitAndKey, LocalhostSplit> featureToTreatmentMap) {
        this._client.updateFeatureToTreatmentMap(featureToTreatmentMap);
        this._manager.updateFeatureToTreatmentMap(featureToTreatmentMap);
    }
}

