/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.matchers;

import io.split.client.SplitClientImpl;
import io.split.engine.matchers.Matcher;
import java.util.List;
import java.util.Map;

public class DependencyMatcher
implements Matcher {
    private String _split;
    private List<String> _treatments;

    public DependencyMatcher(String split, List<String> treatments) {
        this._split = split;
        this._treatments = treatments;
    }

    @Override
    public boolean match(Object matchValue, String bucketingKey, Map<String, Object> attributes, SplitClientImpl splitClient) {
        if (matchValue == null) {
            return false;
        }
        if (!(matchValue instanceof String)) {
            return false;
        }
        String result = splitClient.getTreatmentWithoutImpressions((String)matchValue, bucketingKey, this._split, attributes);
        return this._treatments.contains(result);
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("in split \"");
        bldr.append(this._split);
        bldr.append("\" treatment ");
        bldr.append(this._treatments);
        return bldr.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependencyMatcher that = (DependencyMatcher)o;
        if (this._split != null ? !this._split.equals(that._split) : that._split != null) {
            return false;
        }
        return this._treatments != null ? this._treatments.equals(that._treatments) : that._treatments == null;
    }

    public int hashCode() {
        int result = this._split != null ? this._split.hashCode() : 0;
        result = 31 * result + (this._treatments != null ? this._treatments.hashCode() : 0);
        return result;
    }
}

