/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.impressions;

import com.google.common.annotations.VisibleForTesting;
import io.split.client.dtos.TestImpressions;
import io.split.client.impressions.ImpressionsSender;
import io.split.client.utils.Utils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.org.apache.http.client.methods.CloseableHttpResponse;
import split.org.apache.http.client.methods.HttpPost;
import split.org.apache.http.entity.StringEntity;
import split.org.apache.http.impl.client.CloseableHttpClient;

public class HttpImpressionsSender
implements ImpressionsSender {
    private static final Logger _logger = LoggerFactory.getLogger(HttpImpressionsSender.class);
    private CloseableHttpClient _client;
    private URI _target;

    public static HttpImpressionsSender create(CloseableHttpClient client, URI eventsRootEndpoint) throws URISyntaxException {
        return new HttpImpressionsSender(client, Utils.appendPath(eventsRootEndpoint, "api/testImpressions/bulk"));
    }

    private HttpImpressionsSender(CloseableHttpClient client, URI target) throws URISyntaxException {
        this._client = client;
        this._target = target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void post(List<TestImpressions> impressions) {
        CloseableHttpResponse response;
        block5: {
            response = null;
            try {
                StringEntity entity = Utils.toJsonEntity(impressions);
                HttpPost request = new HttpPost(this._target);
                request.setEntity(entity);
                response = this._client.execute(request);
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) break block5;
                _logger.warn("Response status was: " + status);
            }
            catch (Throwable t) {
                try {
                    _logger.warn("Exception when posting impressions" + impressions, t);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    Utils.forceClose(response);
                }
            }
        }
        Utils.forceClose(response);
    }

    @VisibleForTesting
    URI getTarget() {
        return this._target;
    }
}

