/*
 * Decompiled with CFR 0.152.
 */
package split.org.apache.http.impl.cookie;

import split.org.apache.http.annotation.Immutable;
import split.org.apache.http.cookie.CommonCookieAttributeHandler;
import split.org.apache.http.cookie.Cookie;
import split.org.apache.http.cookie.CookieOrigin;
import split.org.apache.http.cookie.MalformedCookieException;
import split.org.apache.http.cookie.SetCookie;
import split.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import split.org.apache.http.util.Args;

@Immutable
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

