/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.matchers;

import io.split.client.SplitClientImpl;
import io.split.engine.matchers.Matcher;
import io.split.engine.matchers.Transformers;
import java.util.Map;

public class BooleanMatcher
implements Matcher {
    private boolean _booleanValue;

    public BooleanMatcher(boolean booleanValue) {
        this._booleanValue = booleanValue;
    }

    @Override
    public boolean match(Object matchValue, String bucketingKey, Map<String, Object> attributes, SplitClientImpl splitClient) {
        if (matchValue == null) {
            return false;
        }
        Boolean valueAsBoolean = Transformers.asBoolean(matchValue);
        return valueAsBoolean != null && valueAsBoolean == this._booleanValue;
    }

    public String toString() {
        return "is " + Boolean.toString(this._booleanValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BooleanMatcher that = (BooleanMatcher)o;
        return this._booleanValue == that._booleanValue;
    }

    public int hashCode() {
        return this._booleanValue ? 1 : 0;
    }
}

