/*
 * Decompiled with CFR 0.152.
 */
package split.com.google.common.collect;

import java.util.Map;
import javax.annotation.Nullable;
import split.com.google.common.annotations.Beta;
import split.com.google.common.annotations.GwtCompatible;
import split.com.google.common.base.Objects;
import split.com.google.common.collect.ForwardingObject;

@GwtCompatible
public abstract class ForwardingMapEntry<K, V>
extends ForwardingObject
implements Map.Entry<K, V> {
    protected ForwardingMapEntry() {
    }

    @Override
    protected abstract Map.Entry<K, V> delegate();

    @Override
    public K getKey() {
        return this.delegate().getKey();
    }

    @Override
    public V getValue() {
        return this.delegate().getValue();
    }

    @Override
    public V setValue(V value) {
        return this.delegate().setValue(value);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return this.delegate().equals(object);
    }

    @Override
    public int hashCode() {
        return this.delegate().hashCode();
    }

    protected boolean standardEquals(@Nullable Object object) {
        if (object instanceof Map.Entry) {
            Map.Entry that = (Map.Entry)object;
            return Objects.equal(this.getKey(), that.getKey()) && Objects.equal(this.getValue(), that.getValue());
        }
        return false;
    }

    protected int standardHashCode() {
        K k = this.getKey();
        V v = this.getValue();
        return (k == null ? 0 : k.hashCode()) ^ (v == null ? 0 : v.hashCode());
    }

    @Beta
    protected String standardToString() {
        String string = String.valueOf(String.valueOf(this.getKey()));
        String string2 = String.valueOf(String.valueOf(this.getValue()));
        return new StringBuilder(1 + string.length() + string2.length()).append(string).append("=").append(string2).toString();
    }
}

