/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.interceptors;

import io.split.client.SplitClientConfig;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;
import split.org.apache.http.HttpRequest;
import split.org.apache.http.HttpRequestInterceptor;
import split.org.apache.http.protocol.HttpContext;

public class AddSplitHeadersFilter
implements HttpRequestInterceptor {
    private static final Logger _log = LoggerFactory.getLogger(AddSplitHeadersFilter.class);
    static final String AUTHORIZATION_HEADER = "Authorization";
    static final String CLIENT_MACHINE_NAME_HEADER = "SplitSDKMachineName";
    static final String CLIENT_MACHINE_IP_HEADER = "SplitSDKMachineIP";
    static final String CLIENT_VERSION = "SplitSDKVersion";
    private final String _apiTokenBearer;
    private final String _hostname;
    private final String _ip;

    public static AddSplitHeadersFilter instance(String apiToken, boolean ipAddressEnabled) {
        if (!ipAddressEnabled) {
            return new AddSplitHeadersFilter(apiToken, null, null);
        }
        String hostname = null;
        String ip = null;
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            hostname = localHost.getHostName();
            ip = localHost.getHostAddress();
        }
        catch (Exception e) {
            _log.error("Could not resolve InetAddress", (Throwable)e);
        }
        return new AddSplitHeadersFilter(apiToken, hostname, ip);
    }

    private AddSplitHeadersFilter(String apiToken, String hostname, String ip) {
        Preconditions.checkNotNull(apiToken);
        this._apiTokenBearer = "Bearer " + apiToken;
        this._hostname = hostname;
        this._ip = ip;
    }

    @Override
    public void process(HttpRequest request, HttpContext httpContext) {
        request.addHeader(AUTHORIZATION_HEADER, this._apiTokenBearer);
        request.addHeader(CLIENT_VERSION, SplitClientConfig.splitSdkVersion);
        if (this._hostname != null) {
            request.addHeader(CLIENT_MACHINE_NAME_HEADER, this._hostname);
        }
        if (this._ip != null) {
            request.addHeader(CLIENT_MACHINE_IP_HEADER, this._ip);
        }
    }
}

