/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.impressions;

import io.split.client.dtos.KeyImpression;
import io.split.client.utils.MurmurHash3;

public class ImpressionHasher {
    private static final String HASHABLE_FORMAT = "%s:%s:%s:%s:%d";
    private static final String UNKNOWN = "UNKNOWN";

    private static String unknownIfNull(String s) {
        return s == null ? UNKNOWN : s;
    }

    private static Long zeroIfNull(Long l) {
        return l == null ? 0L : l;
    }

    public static Long process(KeyImpression impression) {
        if (null == impression) {
            return null;
        }
        return MurmurHash3.hash128x64(String.format(HASHABLE_FORMAT, ImpressionHasher.unknownIfNull(impression.keyName), ImpressionHasher.unknownIfNull(impression.feature), ImpressionHasher.unknownIfNull(impression.treatment), ImpressionHasher.unknownIfNull(impression.label), ImpressionHasher.zeroIfNull(impression.changeNumber)).getBytes())[0];
    }
}

