/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.segments;

import io.split.client.dtos.SegmentChange;
import io.split.engine.SDKReadinessGates;
import io.split.engine.segments.Segment;
import io.split.engine.segments.SegmentChangeFetcher;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;

public class RefreshableSegment
implements Runnable,
Segment {
    private static final Logger _log = LoggerFactory.getLogger(RefreshableSegment.class);
    private final String _segmentName;
    private final SegmentChangeFetcher _segmentChangeFetcher;
    private final AtomicLong _changeNumber;
    private final SDKReadinessGates _gates;
    private Set<String> _concurrentKeySet = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Object _lock = new Object();

    @Override
    public String segmentName() {
        return this._segmentName;
    }

    @Override
    public boolean contains(String key) {
        return this._concurrentKeySet.contains(key);
    }

    Set<String> fetch() {
        return Collections.unmodifiableSet(this._concurrentKeySet);
    }

    @Override
    public void forceRefresh() {
        this.run();
    }

    @Override
    public long changeNumber() {
        return this._changeNumber.get();
    }

    public static RefreshableSegment create(String segmentName, SegmentChangeFetcher segmentChangeFetcher, SDKReadinessGates gates) {
        return new RefreshableSegment(segmentName, segmentChangeFetcher, -1L, gates);
    }

    public RefreshableSegment(String segmentName, SegmentChangeFetcher segmentChangeFetcher, long changeNumber, SDKReadinessGates gates) {
        this._segmentName = segmentName;
        this._segmentChangeFetcher = segmentChangeFetcher;
        this._changeNumber = new AtomicLong(changeNumber);
        this._gates = gates;
        Preconditions.checkNotNull(this._segmentChangeFetcher);
        Preconditions.checkNotNull(this._segmentName);
        Preconditions.checkNotNull(this._gates);
    }

    @Override
    public void run() {
        block3: {
            try {
                long end;
                long start;
                this._gates.registerSegment(this._segmentName);
                do {
                    start = this._changeNumber.get();
                    this.runWithoutExceptionHandling();
                    end = this._changeNumber.get();
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug(this._segmentName + " segment fetch before: " + start + ", after: " + this._changeNumber.get() + " size: " + this._concurrentKeySet.size());
                } while (start < end);
                this._gates.segmentIsReady(this._segmentName);
            }
            catch (Throwable t) {
                _log.error("RefreshableSegmentFetcher failed: " + t.getMessage());
                if (!_log.isDebugEnabled()) break block3;
                _log.debug("Reason:", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWithoutExceptionHandling() {
        SegmentChange change = this._segmentChangeFetcher.fetch(this._segmentName, this._changeNumber.get());
        if (change == null) {
            throw new IllegalStateException("SegmentChange was null");
        }
        if (change.till == this._changeNumber.get()) {
            return;
        }
        if (change.since != this._changeNumber.get() || change.since < this._changeNumber.get()) {
            return;
        }
        if (change.added.isEmpty() && change.removed.isEmpty()) {
            this._changeNumber.set(change.till);
            return;
        }
        Object object = this._lock;
        synchronized (object) {
            if (change.since != this._changeNumber.get() || change.till < this._changeNumber.get()) {
                return;
            }
            for (String added : change.added) {
                this._concurrentKeySet.add(added);
            }
            if (!change.added.isEmpty()) {
                _log.info(this._segmentName + " added keys: " + this.summarize(change.added));
            }
            for (String removed : change.removed) {
                this._concurrentKeySet.remove(removed);
            }
            if (!change.removed.isEmpty()) {
                _log.info(this._segmentName + " removed keys: " + this.summarize(change.removed));
            }
            this._changeNumber.set(change.till);
        }
    }

    private String summarize(List<String> changes) {
        StringBuilder bldr = new StringBuilder();
        bldr.append("[");
        for (int i = 0; i < Math.min(3, changes.size()); ++i) {
            if (i != 0) {
                bldr.append(", ");
            }
            bldr.append(changes.get(i));
        }
        if (changes.size() > 3) {
            bldr.append("... ");
            bldr.append(changes.size() - 3);
            bldr.append(" others");
        }
        bldr.append("]");
        return bldr.toString();
    }

    public String toString() {
        return "RefreshableSegmentFetcher[" + this._segmentName + "]";
    }
}

