/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.sse;

import io.split.engine.sse.EventSourceClient;
import io.split.engine.sse.NotificationParser;
import io.split.engine.sse.NotificationParserImp;
import io.split.engine.sse.NotificationProcessor;
import io.split.engine.sse.NotificationProcessorImp;
import io.split.engine.sse.PushStatusTracker;
import io.split.engine.sse.SplitSseEventSource;
import io.split.engine.sse.SseStatus;
import io.split.engine.sse.dtos.SegmentQueueDto;
import io.split.engine.sse.exceptions.EventParsingException;
import io.split.engine.sse.workers.SplitsWorker;
import io.split.engine.sse.workers.Worker;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.sse.InboundSseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.annotations.VisibleForTesting;
import split.com.google.common.base.Preconditions;
import split.org.apache.http.client.utils.URIBuilder;

public class EventSourceClientImp
implements EventSourceClient {
    private static final Logger _log = LoggerFactory.getLogger(EventSourceClient.class);
    private final String _baseStreamingUrl;
    private final Client _client;
    private final NotificationParser _notificationParser;
    private final NotificationProcessor _notificationProcessor;
    private final SplitSseEventSource _splitSseEventSource;
    private final PushStatusTracker _pushStatusTracker;

    @VisibleForTesting
    EventSourceClientImp(String baseStreamingUrl, NotificationParser notificationParser, NotificationProcessor notificationProcessor, Client client, PushStatusTracker pushStatusTracker) {
        this._baseStreamingUrl = Preconditions.checkNotNull(baseStreamingUrl);
        this._notificationParser = Preconditions.checkNotNull(notificationParser);
        this._notificationProcessor = Preconditions.checkNotNull(notificationProcessor);
        this._client = Preconditions.checkNotNull(client);
        this._splitSseEventSource = new SplitSseEventSource(inboundEvent -> {
            this.onMessage((InboundSseEvent)inboundEvent);
            return null;
        }, status -> {
            this.onSSeStatusChange((SseStatus)((Object)status));
            return null;
        });
        this._pushStatusTracker = pushStatusTracker;
    }

    public static EventSourceClientImp build(String baseStreamingUrl, SplitsWorker splitsWorker, Worker<SegmentQueueDto> segmentWorker, PushStatusTracker pushStatusTracker) {
        return new EventSourceClientImp(baseStreamingUrl, new NotificationParserImp(), NotificationProcessorImp.build(splitsWorker, segmentWorker, pushStatusTracker), ClientBuilder.newBuilder().readTimeout(70L, TimeUnit.SECONDS).build(), pushStatusTracker);
    }

    @Override
    public boolean start(String channelList, String token) {
        if (this._splitSseEventSource.isOpen()) {
            this._splitSseEventSource.close();
        }
        try {
            return this._splitSseEventSource.open(this.buildTarget(channelList, token));
        }
        catch (URISyntaxException e) {
            _log.error("Error building Streaming URI: " + e.getMessage());
            return false;
        }
    }

    @Override
    public void stop() {
        if (!this._splitSseEventSource.isOpen()) {
            _log.warn("Event Source Client is closed.");
            return;
        }
        this._splitSseEventSource.close();
    }

    private WebTarget buildTarget(String channelList, String token) throws URISyntaxException {
        return this._client.target(new URIBuilder(this._baseStreamingUrl).addParameter("channels", channelList).addParameter("v", "1.1").addParameter("accessToken", token).build());
    }

    private void onMessage(InboundSseEvent event) {
        try {
            String type = event.getName();
            String payload = event.readData();
            if (payload.length() > 0) {
                _log.debug(String.format("Payload received: %s", payload));
                switch (type) {
                    case "message": {
                        this._notificationProcessor.process(this._notificationParser.parseMessage(payload));
                        break;
                    }
                    case "error": {
                        this._pushStatusTracker.handleIncomingAblyError(this._notificationParser.parseError(payload));
                        break;
                    }
                    default: {
                        throw new EventParsingException("Wrong notification type.", payload);
                    }
                }
            }
        }
        catch (EventParsingException ex) {
            _log.debug(String.format("Error parsing the event: %s. Payload: %s", ex.getMessage(), ex.getPayload()));
        }
        catch (Exception e) {
            _log.warn(String.format("Error onMessage: %s", e.getMessage()));
        }
    }

    private void onSSeStatusChange(SseStatus status) {
        this._pushStatusTracker.handleSseStatus(status);
    }
}

