/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.sse.client;

import io.split.engine.sse.client.RawEvent;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.SocketException;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;
import split.com.google.common.base.Strings;
import split.org.apache.http.client.config.RequestConfig;
import split.org.apache.http.client.methods.CloseableHttpResponse;
import split.org.apache.http.client.methods.HttpGet;
import split.org.apache.http.impl.client.CloseableHttpClient;
import split.org.apache.http.impl.client.HttpClients;
import split.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class SSEClient {
    private static final String SOCKET_CLOSED_MESSAGE = "Socket closed";
    private static final String KEEP_ALIVE_PAYLOAD = ":keepalive\n";
    private static final Integer CONNECT_TIMEOUT = 30000;
    private static final Integer SOCKET_TIMEOUT = 70000;
    private static final Logger _log = LoggerFactory.getLogger(SSEClient.class);
    private final CloseableHttpClient _client;
    private final Function<RawEvent, Void> _eventCallback;
    private final Function<StatusMessage, Void> _statusCallback;
    private final AtomicReference<ConnectionState> _state = new AtomicReference<ConnectionState>(ConnectionState.CLOSED);
    private final AtomicReference<CloseableHttpResponse> _ongoingResponse = new AtomicReference();

    public SSEClient(Function<RawEvent, Void> eventCallback, Function<StatusMessage, Void> statusCallback) {
        this._client = SSEClient.buildHttpClient();
        this._eventCallback = eventCallback;
        this._statusCallback = statusCallback;
    }

    public synchronized boolean open(URI uri) {
        if (this.isOpen()) {
            _log.warn("SSEClient already open.");
            return false;
        }
        this._statusCallback.apply(StatusMessage.INITIALIZATION_IN_PROGRESS);
        CountDownLatch signal = new CountDownLatch(1);
        Thread thread = new Thread(() -> this.connectAndLoop(uri, signal));
        thread.setDaemon(true);
        thread.start();
        try {
            if (!signal.await(CONNECT_TIMEOUT.intValue(), TimeUnit.SECONDS)) {
                return false;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            _log.warn(e.getMessage());
            return false;
        }
        return this.isOpen();
    }

    public boolean isOpen() {
        return ConnectionState.OPEN.equals((Object)this._state.get());
    }

    public synchronized void close() {
        if (this._state.compareAndSet(ConnectionState.OPEN, ConnectionState.CLOSED) && this._ongoingResponse.get() != null) {
            try {
                this._ongoingResponse.get().close();
            }
            catch (IOException e) {
                _log.warn(String.format("Error closing SSEClient: %s", e.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void connectAndLoop(URI uri, CountDownLatch signal) {
        Preconditions.checkNotNull(uri);
        Preconditions.checkNotNull(signal);
        if (!this.establishConnection(uri, signal)) {
            this._statusCallback.apply(StatusMessage.NONRETRYABLE_ERROR);
            return;
        }
        try {
            InputStream stream = this._ongoingResponse.get().getEntity().getContent();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            while (this.isOpen() && !Thread.currentThread().isInterrupted()) {
                try {
                    this.handleMessage(SSEClient.readMessageAsString(reader));
                }
                catch (SocketException exc) {
                    _log.warn(exc.getMessage());
                    if (SOCKET_CLOSED_MESSAGE.equals(exc.getMessage())) {
                        this._statusCallback.apply(StatusMessage.FORCED_STOP);
                        try {
                            this._ongoingResponse.get().close();
                        }
                        catch (IOException e) {
                            _log.warn(e.getMessage());
                        }
                        this._state.set(ConnectionState.CLOSED);
                        _log.warn("SSEClient finished.");
                        return;
                    }
                    this._statusCallback.apply(StatusMessage.RETRYABLE_ERROR);
                    try {
                        this._ongoingResponse.get().close();
                    }
                    catch (IOException e) {
                        _log.warn(e.getMessage());
                    }
                    this._state.set(ConnectionState.CLOSED);
                    _log.warn("SSEClient finished.");
                    return;
                }
                catch (IOException exc) {
                    _log.warn(exc.getMessage());
                    this._statusCallback.apply(StatusMessage.RETRYABLE_ERROR);
                    try {
                        this._ongoingResponse.get().close();
                    }
                    catch (IOException e) {
                        _log.warn(e.getMessage());
                    }
                    this._state.set(ConnectionState.CLOSED);
                    _log.warn("SSEClient finished.");
                    return;
                    {
                        catch (Exception e) {
                            _log.error(e.getMessage(), (Throwable)e);
                            this._statusCallback.apply(StatusMessage.NONRETRYABLE_ERROR);
                            return;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                            return;
                        }
                    }
                }
            }
        }
        finally {
            try {
                this._ongoingResponse.get().close();
            }
            catch (IOException e) {
                _log.warn(e.getMessage());
            }
            this._state.set(ConnectionState.CLOSED);
            _log.warn("SSEClient finished.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean establishConnection(URI uri, CountDownLatch signal) {
        HttpGet request = new HttpGet(uri);
        try {
            this._ongoingResponse.set(this._client.execute(request));
            if (this._ongoingResponse.get().getStatusLine().getStatusCode() != 200) {
                boolean bl = false;
                return bl;
            }
            this._state.set(ConnectionState.OPEN);
            this._statusCallback.apply(StatusMessage.CONNECTED);
        }
        catch (IOException exc) {
            _log.warn(String.format("Error establishConnection: %s", exc));
            boolean bl = false;
            return bl;
        }
        finally {
            signal.countDown();
        }
        return true;
    }

    private static String readMessageAsString(BufferedReader reader) throws IOException {
        StringBuilder lines = new StringBuilder();
        while (true) {
            String line;
            if (null == (line = reader.readLine())) {
                throw new EOFException("connection closed by remote host");
            }
            if (line.isEmpty()) {
                return lines.toString();
            }
            lines.append(line).append("\n");
        }
    }

    private static CloseableHttpClient buildHttpClient() {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(CONNECT_TIMEOUT).setSocketTimeout(SOCKET_TIMEOUT).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(1);
        cm.setDefaultMaxPerRoute(1);
        return HttpClients.custom().setConnectionManager(cm).setDefaultRequestConfig(requestConfig).build();
    }

    private void handleMessage(String message) {
        if (Strings.isNullOrEmpty(message) || KEEP_ALIVE_PAYLOAD.equals(message)) {
            _log.debug("Keep Alive event");
            return;
        }
        RawEvent e = RawEvent.fromString(message);
        this._eventCallback.apply(e);
    }

    private static enum ConnectionState {
        OPEN,
        CLOSED;

    }

    public static enum StatusMessage {
        CONNECTED,
        RETRYABLE_ERROR,
        NONRETRYABLE_ERROR,
        INITIALIZATION_IN_PROGRESS,
        FORCED_STOP;

    }
}

