/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.impressions;

import io.split.client.SplitClientConfig;
import io.split.client.dtos.KeyImpression;
import io.split.client.dtos.TestImpressions;
import io.split.client.impressions.HttpImpressionsSender;
import io.split.client.impressions.Impression;
import io.split.client.impressions.ImpressionCounter;
import io.split.client.impressions.ImpressionListener;
import io.split.client.impressions.ImpressionObserver;
import io.split.client.impressions.ImpressionUtils;
import io.split.client.impressions.ImpressionsManager;
import io.split.client.impressions.ImpressionsSender;
import io.split.client.impressions.ImpressionsStorage;
import io.split.client.impressions.InMemoryImpressionsStorage;
import java.io.Closeable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.annotations.VisibleForTesting;
import split.com.google.common.base.Preconditions;
import split.com.google.common.util.concurrent.ThreadFactoryBuilder;
import split.org.apache.http.impl.client.CloseableHttpClient;

public class ImpressionsManagerImpl
implements ImpressionsManager,
Closeable {
    private static final Logger _log = LoggerFactory.getLogger(ImpressionsManagerImpl.class);
    private static final long BULK_INITIAL_DELAY_SECONDS = 10L;
    private static final long COUNT_INITIAL_DELAY_SECONDS = 100L;
    private static final long COUNT_REFRESH_RATE_SECONDS = 1800L;
    private static final long LAST_SEEN_CACHE_SIZE = 500000L;
    private final SplitClientConfig _config;
    private final ImpressionsStorage _storage;
    private final ScheduledExecutorService _scheduler;
    private final ImpressionsSender _impressionsSender;
    private final ImpressionObserver _impressionObserver;
    private final ImpressionCounter _counter;
    private final ImpressionListener _listener;
    private final ImpressionsManager.Mode _mode;

    public static ImpressionsManagerImpl instance(CloseableHttpClient client, SplitClientConfig config, List<ImpressionListener> listeners) throws URISyntaxException {
        return new ImpressionsManagerImpl(client, config, null, listeners);
    }

    public static ImpressionsManagerImpl instanceForTest(CloseableHttpClient client, SplitClientConfig config, ImpressionsSender impressionsSender, List<ImpressionListener> listeners) throws URISyntaxException {
        return new ImpressionsManagerImpl(client, config, impressionsSender, listeners);
    }

    private ImpressionsManagerImpl(CloseableHttpClient client, SplitClientConfig config, ImpressionsSender impressionsSender, List<ImpressionListener> listeners) throws URISyntaxException {
        this._config = Preconditions.checkNotNull(config);
        this._mode = Preconditions.checkNotNull(config.impressionsMode());
        this._storage = new InMemoryImpressionsStorage(config.impressionsQueueSize());
        this._impressionObserver = new ImpressionObserver(500000L);
        this._counter = new ImpressionCounter();
        this._impressionsSender = null != impressionsSender ? impressionsSender : HttpImpressionsSender.create(client, URI.create(config.eventsEndpoint()), this._mode);
        this._scheduler = this.buildExecutor();
        this._scheduler.scheduleAtFixedRate(this::sendImpressions, 10L, config.impressionsRefreshRate(), TimeUnit.SECONDS);
        if (ImpressionsManager.Mode.OPTIMIZED.equals((Object)this._mode)) {
            this._scheduler.scheduleAtFixedRate(this::sendImpressionCounters, 100L, 1800L, TimeUnit.SECONDS);
        }
        this._listener = null != listeners && !listeners.isEmpty() ? new ImpressionListener.FederatedImpressionListener(listeners) : new ImpressionListener.NoopImpressionListener();
    }

    private static boolean shouldQueueImpression(Impression i) {
        return Objects.isNull(i.pt()) || ImpressionUtils.truncateTimeframe(i.pt()) != ImpressionUtils.truncateTimeframe(i.time());
    }

    @Override
    public void track(Impression impression) {
        if (null == impression) {
            return;
        }
        impression = impression.withPreviousTime(this._impressionObserver.testAndSet(impression));
        this._listener.log(impression);
        if (ImpressionsManager.Mode.OPTIMIZED.equals((Object)this._mode)) {
            this._counter.inc(impression.split(), impression.time(), 1);
        }
        if (ImpressionsManager.Mode.DEBUG.equals((Object)this._mode) || ImpressionsManagerImpl.shouldQueueImpression(impression)) {
            this._storage.put(KeyImpression.fromImpression(impression));
        }
    }

    @Override
    public void close() {
        try {
            this._listener.close();
            _log.info("Successful shutdown of ImpressionListener");
            this._scheduler.shutdown();
            this.sendImpressions();
            this._scheduler.awaitTermination(this._config.waitBeforeShutdown(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            _log.warn("Unable to close ImpressionsManager properly", (Throwable)e);
        }
    }

    @VisibleForTesting
    void sendImpressions() {
        if (this._storage.isFull()) {
            _log.warn("Split SDK impressions queue is full. Impressions may have been dropped. Consider increasing capacity.");
        }
        long start = System.currentTimeMillis();
        List<KeyImpression> impressions = this._storage.pop();
        if (impressions.isEmpty()) {
            return;
        }
        this._impressionsSender.postImpressionsBulk(TestImpressions.fromKeyImpressions(impressions));
        if (this._config.debugEnabled()) {
            _log.info(String.format("Posting %d Split impressions took %d millis", impressions.size(), System.currentTimeMillis() - start));
        }
    }

    @VisibleForTesting
    void sendImpressionCounters() {
        if (!this._counter.isEmpty()) {
            this._impressionsSender.postCounters(this._counter.popAll());
        }
    }

    private ScheduledExecutorService buildExecutor() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Split-ImpressionsManager-%d").build();
        return Executors.newScheduledThreadPool(2, threadFactory);
    }
}

