/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.common;

import io.split.engine.common.Synchronizer;
import io.split.engine.experiments.RefreshableSplitFetcher;
import io.split.engine.experiments.RefreshableSplitFetcherProvider;
import io.split.engine.segments.RefreshableSegmentFetcher;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;
import split.com.google.common.util.concurrent.ThreadFactoryBuilder;

public class SynchronizerImp
implements Synchronizer {
    private static final Logger _log = LoggerFactory.getLogger(Synchronizer.class);
    private final RefreshableSplitFetcherProvider _refreshableSplitFetcherProvider;
    private final RefreshableSplitFetcher _splitFetcher;
    private final RefreshableSegmentFetcher _segmentFetcher;
    private final ScheduledExecutorService _syncAllScheduledExecutorService;

    public SynchronizerImp(RefreshableSplitFetcherProvider refreshableSplitFetcherProvider, RefreshableSegmentFetcher segmentFetcher) {
        this._refreshableSplitFetcherProvider = Preconditions.checkNotNull(refreshableSplitFetcherProvider);
        this._splitFetcher = Preconditions.checkNotNull(this._refreshableSplitFetcherProvider.getFetcher());
        this._segmentFetcher = Preconditions.checkNotNull(segmentFetcher);
        ThreadFactory splitsThreadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Split-SyncAll-%d").build();
        this._syncAllScheduledExecutorService = Executors.newSingleThreadScheduledExecutor(splitsThreadFactory);
    }

    @Override
    public void syncAll() {
        this._syncAllScheduledExecutorService.schedule(() -> {
            this._splitFetcher.forceRefresh();
            this._segmentFetcher.forceRefreshAll();
        }, 0L, TimeUnit.SECONDS);
    }

    @Override
    public void startPeriodicFetching() {
        _log.debug("Starting Periodic Fetching ...");
        this._refreshableSplitFetcherProvider.startPeriodicFetching();
        this._segmentFetcher.startPeriodicFetching();
    }

    @Override
    public void stopPeriodicFetching() {
        _log.debug("Stop Periodic Fetching ...");
        this._refreshableSplitFetcherProvider.stop();
        this._segmentFetcher.stop();
    }

    @Override
    public void refreshSplits(long targetChangeNumber) {
        if (targetChangeNumber > this._splitFetcher.changeNumber()) {
            this._splitFetcher.forceRefresh();
        }
    }

    @Override
    public void localKillSplit(String splitName, String defaultTreatment, long newChangeNumber) {
        if (newChangeNumber > this._splitFetcher.changeNumber()) {
            this._splitFetcher.killSplit(splitName, defaultTreatment, newChangeNumber);
        }
    }

    @Override
    public void refreshSegment(String segmentName, long changeNumber) {
        if (changeNumber > this._segmentFetcher.getChangeNumber(segmentName)) {
            this._segmentFetcher.forceRefresh(segmentName);
        }
    }
}

