/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.utils;

import io.split.client.utils.Json;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import split.com.google.common.base.Charsets;
import split.com.google.common.base.Preconditions;
import split.org.apache.http.client.methods.CloseableHttpResponse;
import split.org.apache.http.client.utils.URIBuilder;
import split.org.apache.http.entity.StringEntity;

public class Utils {
    public static StringEntity toJsonEntity(Object obj) {
        String json = Json.toJson(obj);
        StringEntity entity = new StringEntity(json, Charsets.UTF_8);
        entity.setContentType("application/json");
        return entity;
    }

    public static void forceClose(CloseableHttpResponse response) {
        try {
            if (response != null) {
                response.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static URI appendPath(URI root, String pathToAppend) throws URISyntaxException {
        Preconditions.checkNotNull(root);
        Preconditions.checkNotNull(pathToAppend);
        String path = String.format("%s%s%s", root.getPath(), root.getPath().endsWith("/") ? "" : "/", pathToAppend);
        return new URIBuilder(root).setPath(path).build();
    }
}

