/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.interceptors;

import io.split.client.SplitClientConfig;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;

public class AddSplitHeadersFilter
implements HttpRequestInterceptor {
    private static final Logger _log = LoggerFactory.getLogger(AddSplitHeadersFilter.class);
    static final String AUTHORIZATION_HEADER = "Authorization";
    static final String CLIENT_MACHINE_NAME_HEADER = "SplitSDKMachineName";
    static final String CLIENT_MACHINE_IP_HEADER = "SplitSDKMachineIP";
    static final String CLIENT_VERSION = "SplitSDKVersion";
    private final String _apiTokenBearer;
    private final String _hostname;
    private final String _ip;

    public static AddSplitHeadersFilter instance(String apiToken, boolean ipAddressEnabled) {
        if (!ipAddressEnabled) {
            return new AddSplitHeadersFilter(apiToken, null, null);
        }
        String hostname = null;
        String ip = null;
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            hostname = localHost.getHostName();
            ip = localHost.getHostAddress();
        }
        catch (Exception e) {
            _log.error("Could not resolve InetAddress", (Throwable)e);
        }
        return new AddSplitHeadersFilter(apiToken, hostname, ip);
    }

    private AddSplitHeadersFilter(String apiToken, String hostname, String ip) {
        Preconditions.checkNotNull(apiToken);
        this._apiTokenBearer = "Bearer " + apiToken;
        this._hostname = hostname;
        this._ip = ip;
    }

    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        request.addHeader(AUTHORIZATION_HEADER, (Object)this._apiTokenBearer);
        request.addHeader(CLIENT_VERSION, (Object)SplitClientConfig.splitSdkVersion);
        if (this._hostname != null) {
            request.addHeader(CLIENT_MACHINE_NAME_HEADER, (Object)this._hostname);
        }
        if (this._ip != null) {
            request.addHeader(CLIENT_MACHINE_IP_HEADER, (Object)this._ip);
        }
    }
}

