/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.common;

import java.util.concurrent.atomic.AtomicInteger;
import split.com.google.common.base.Preconditions;

public class Backoff {
    private static final long BACKOFF_MAX_SECONDS_ALLOWED = 1800L;
    private final long _backoffBase;
    private AtomicInteger _attempt;

    public Backoff(long backoffBase) {
        this._backoffBase = Preconditions.checkNotNull(backoffBase);
        this._attempt = new AtomicInteger(0);
    }

    public long interval() {
        long interval = this._backoffBase * (long)Math.pow(2.0, this._attempt.getAndIncrement());
        return interval >= 1800L ? 1800L : interval;
    }

    public synchronized void reset() {
        this._attempt.set(0);
    }
}

