/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.cache.SplitCache;
import io.split.client.EventClient;
import io.split.client.SplitClient;
import io.split.client.SplitClientConfig;
import io.split.client.SplitFactory;
import io.split.client.api.Key;
import io.split.client.api.SplitResult;
import io.split.client.dtos.Event;
import io.split.client.impressions.Impression;
import io.split.client.impressions.ImpressionsManager;
import io.split.engine.SDKReadinessGates;
import io.split.engine.evaluator.Evaluator;
import io.split.engine.evaluator.EvaluatorImp;
import io.split.engine.metrics.Metrics;
import io.split.inputValidation.EventsValidator;
import io.split.inputValidation.KeyValidator;
import io.split.inputValidation.SplitNameValidator;
import io.split.inputValidation.TrafficTypeValidator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;

public final class SplitClientImpl
implements SplitClient {
    public static final SplitResult SPLIT_RESULT_CONTROL = new SplitResult("control", null);
    private static final String GET_TREATMENT = "getTreatment";
    private static final String GET_TREATMENT_WITH_CONFIG = "getTreatmentWithConfig";
    private static final Logger _log = LoggerFactory.getLogger(SplitClientImpl.class);
    private final SplitFactory _container;
    private final SplitCache _splitCache;
    private final ImpressionsManager _impressionManager;
    private final Metrics _metrics;
    private final SplitClientConfig _config;
    private final EventClient _eventClient;
    private final SDKReadinessGates _gates;
    private final Evaluator _evaluator;

    public SplitClientImpl(SplitFactory container, SplitCache splitCache, ImpressionsManager impressionManager, Metrics metrics, EventClient eventClient, SplitClientConfig config, SDKReadinessGates gates, Evaluator evaluator) {
        this._container = container;
        this._splitCache = Preconditions.checkNotNull(splitCache);
        this._impressionManager = Preconditions.checkNotNull(impressionManager);
        this._metrics = metrics;
        this._eventClient = eventClient;
        this._config = config;
        this._gates = Preconditions.checkNotNull(gates);
        this._evaluator = Preconditions.checkNotNull(evaluator);
    }

    @Override
    public String getTreatment(String key, String split) {
        return this.getTreatment(key, split, Collections.emptyMap());
    }

    @Override
    public String getTreatment(String key, String split, Map<String, Object> attributes) {
        return this.getTreatmentWithConfigInternal(GET_TREATMENT, key, null, split, attributes).treatment();
    }

    @Override
    public String getTreatment(Key key, String split, Map<String, Object> attributes) {
        return this.getTreatmentWithConfigInternal(GET_TREATMENT, key.matchingKey(), key.bucketingKey(), split, attributes).treatment();
    }

    @Override
    public SplitResult getTreatmentWithConfig(String key, String split) {
        return this.getTreatmentWithConfigInternal(GET_TREATMENT_WITH_CONFIG, key, null, split, Collections.emptyMap());
    }

    @Override
    public SplitResult getTreatmentWithConfig(String key, String split, Map<String, Object> attributes) {
        return this.getTreatmentWithConfigInternal(GET_TREATMENT_WITH_CONFIG, key, null, split, attributes);
    }

    @Override
    public SplitResult getTreatmentWithConfig(Key key, String split, Map<String, Object> attributes) {
        return this.getTreatmentWithConfigInternal(GET_TREATMENT_WITH_CONFIG, key.matchingKey(), key.bucketingKey(), split, attributes);
    }

    @Override
    public boolean track(String key, String trafficType, String eventType) {
        Event event = this.createEvent(key, trafficType, eventType);
        return this.track(event);
    }

    @Override
    public boolean track(String key, String trafficType, String eventType, double value) {
        Event event = this.createEvent(key, trafficType, eventType);
        event.value = value;
        return this.track(event);
    }

    @Override
    public boolean track(String key, String trafficType, String eventType, Map<String, Object> properties) {
        Event event = this.createEvent(key, trafficType, eventType);
        event.properties = new HashMap<String, Object>(properties);
        return this.track(event);
    }

    @Override
    public boolean track(String key, String trafficType, String eventType, double value, Map<String, Object> properties) {
        Event event = this.createEvent(key, trafficType, eventType);
        event.properties = new HashMap<String, Object>(properties);
        event.value = value;
        return this.track(event);
    }

    @Override
    public void blockUntilReady() throws TimeoutException, InterruptedException {
        long startTime = System.currentTimeMillis();
        if (this._config.blockUntilReady() <= 0) {
            throw new IllegalArgumentException("setBlockUntilReadyTimeout must be positive but in config was: " + this._config.blockUntilReady());
        }
        if (!this._gates.isSDKReady(this._config.blockUntilReady())) {
            throw new TimeoutException("SDK was not ready in " + this._config.blockUntilReady() + " milliseconds");
        }
        _log.debug(String.format("Split SDK ready in %d ms", System.currentTimeMillis() - startTime));
    }

    @Override
    public void destroy() {
        this._container.destroy();
    }

    private boolean track(Event event) {
        if (this._container.isDestroyed()) {
            _log.error("Client has already been destroyed - no calls possible");
            return false;
        }
        Optional<String> trafficTypeResult = TrafficTypeValidator.isValid(event.trafficTypeName, this._splitCache, "track");
        if (!trafficTypeResult.isPresent()) {
            return false;
        }
        event.trafficTypeName = trafficTypeResult.get();
        if (!EventsValidator.typeIsValid(event.eventTypeId, "track")) {
            return false;
        }
        if (!KeyValidator.isValid(event.key, "key", this._config.maxStringLength(), "track")) {
            return false;
        }
        EventsValidator.EventValidatorResult propertiesResult = EventsValidator.propertiesAreValid(event.properties);
        if (!propertiesResult.getSuccess()) {
            return false;
        }
        event.properties = propertiesResult.getValue();
        return this._eventClient.track(event, propertiesResult.getEventSize());
    }

    private SplitResult getTreatmentWithConfigInternal(String method, String matchingKey, String bucketingKey, String split, Map<String, Object> attributes) {
        try {
            if (this._container.isDestroyed()) {
                _log.error("Client has already been destroyed - no calls possible");
                return SPLIT_RESULT_CONTROL;
            }
            if (!KeyValidator.isValid(matchingKey, "matchingKey", this._config.maxStringLength(), method)) {
                return SPLIT_RESULT_CONTROL;
            }
            if (!KeyValidator.bucketingKeyIsValid(bucketingKey, this._config.maxStringLength(), method)) {
                return SPLIT_RESULT_CONTROL;
            }
            Optional<String> splitNameResult = SplitNameValidator.isValid(split, method);
            if (!splitNameResult.isPresent()) {
                return SPLIT_RESULT_CONTROL;
            }
            split = splitNameResult.get();
            long start = System.currentTimeMillis();
            EvaluatorImp.TreatmentLabelAndChangeNumber result = this._evaluator.evaluateFeature(matchingKey, bucketingKey, split, attributes);
            if (result.treatment.equals("control") && result.label.equals("definition not found") && this._gates.isSDKReadyNow()) {
                _log.warn("getTreatment: you passed \"" + split + "\" that does not exist in this environment, please double check what Splits exist in the web console.");
            }
            this.recordStats(matchingKey, bucketingKey, split, start, result.treatment, String.format("sdk.%s", method), this._config.labelsEnabled() ? result.label : null, result.changeNumber, attributes);
            return new SplitResult(result.treatment, result.configurations);
        }
        catch (Exception e) {
            try {
                _log.error("CatchAll Exception", (Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return SPLIT_RESULT_CONTROL;
        }
    }

    private void recordStats(String matchingKey, String bucketingKey, String split, long start, String result, String operation, String label, Long changeNumber, Map<String, Object> attributes) {
        try {
            this._impressionManager.track(new Impression(matchingKey, bucketingKey, split, result, System.currentTimeMillis(), label, changeNumber, attributes));
            this._metrics.time(operation, System.currentTimeMillis() - start);
        }
        catch (Throwable t) {
            _log.error("Exception", t);
        }
    }

    private Event createEvent(String key, String trafficType, String eventType) {
        Event event = new Event();
        event.eventTypeId = eventType;
        event.trafficTypeName = trafficType;
        event.key = key;
        event.timestamp = System.currentTimeMillis();
        return event;
    }
}

